/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.gui.widget;

import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import mods.railcraft.gui.widget.Gauge;
import mods.railcraft.gui.widget.Widget;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;

public class GaugeWidget
extends Widget {
    private final Gauge gauge;
    private final boolean vertical;
    private final Object2FloatMap<ServerPlayer> previousValues = new Object2FloatOpenHashMap();
    private boolean first = true;
    private float measurement;

    public GaugeWidget(Gauge gauge, int x, int y, int u, int v, int w, int h) {
        this(gauge, x, y, u, v, w, h, true);
    }

    public GaugeWidget(Gauge gauge, int x, int y, int u, int v, int w, int h, boolean vertical) {
        super(x, y, u, v, w, h);
        this.gauge = gauge;
        this.vertical = vertical;
    }

    public final float getMeasurement() {
        if (this.first) {
            this.measurement = this.gauge.getMeasurement();
            this.first = false;
        } else {
            this.measurement = (this.gauge.getMeasurement() - this.measurement) * 0.1f + this.measurement;
        }
        return this.measurement;
    }

    public Gauge getGauge() {
        return this.gauge;
    }

    public boolean isVertical() {
        return this.vertical;
    }

    @Override
    public boolean requiresSync(ServerPlayer listener) {
        float previousValue = this.previousValues.getOrDefault((Object)listener, 0.0f);
        return previousValue != this.gauge.getServerValue();
    }

    @Override
    public void writeToBuf(ServerPlayer listener, RegistryFriendlyByteBuf data) {
        float value = this.gauge.getServerValue();
        data.writeFloat(value);
        this.previousValues.put((Object)listener, value);
    }

    @Override
    public void readFromBuf(RegistryFriendlyByteBuf data) {
        this.gauge.setClientValue(data.readFloat());
        this.gauge.refresh();
    }
}

