/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.network.to_server;

import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.util.LevelUtil;
import mods.railcraft.world.level.block.entity.manipulator.ItemManipulatorBlockEntity;
import mods.railcraft.world.level.block.entity.manipulator.ManipulatorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record SetItemManipulatorMessage(BlockPos blockPos, ManipulatorBlockEntity.RedstoneMode redstoneMode, ManipulatorBlockEntity.TransferMode transferMode) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SetItemManipulatorMessage> TYPE = new CustomPacketPayload.Type(RailcraftConstants.rl("set_item_manipulator"));
    public static final StreamCodec<FriendlyByteBuf, SetItemManipulatorMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, SetItemManipulatorMessage::blockPos, (StreamCodec)NeoForgeStreamCodecs.enumCodec(ManipulatorBlockEntity.RedstoneMode.class), SetItemManipulatorMessage::redstoneMode, (StreamCodec)NeoForgeStreamCodecs.enumCodec(ManipulatorBlockEntity.TransferMode.class), SetItemManipulatorMessage::transferMode, SetItemManipulatorMessage::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(SetItemManipulatorMessage message, IPayloadContext context) {
        Level level = context.player().level();
        LevelUtil.getBlockEntity((BlockGetter)level, message.blockPos, ItemManipulatorBlockEntity.class).ifPresent(manipulator -> {
            manipulator.setRedstoneMode(message.redstoneMode);
            manipulator.setTransferMode(message.transferMode);
            manipulator.setChanged();
        });
    }
}

