/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.util.fluids;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import mods.railcraft.util.container.ContainerMapper;
import mods.railcraft.world.level.material.StandardTank;
import mods.railcraft.world.level.material.TankManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public final class FluidTools {
    public static final int BUCKET_FILL_TIME = 8;
    public static final int NETWORK_UPDATE_INTERVAL = 128;
    public static final int PROCESS_VOLUME = 4000;

    private FluidTools() {
    }

    public static Component toString(FluidStack fluidStack) {
        if (fluidStack.isEmpty()) {
            return Component.literal((String)"Empty");
        }
        return Component.literal((String)(fluidStack.getAmount() + "x")).append(fluidStack.getHoverName());
    }

    public static boolean interactWithFluidHandler(Player player, InteractionHand hand, IFluidHandler fluidHandler) {
        return player.level().isClientSide() ? FluidTools.isFluidHandler(player.getItemInHand(hand)) : FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)fluidHandler);
    }

    public static boolean isFluidHandler(ItemStack stack) {
        return FluidUtil.getFluidHandler((ItemStack)stack).isPresent();
    }

    public static boolean isEmptyContainer(ItemStack stack) {
        return FluidUtil.getFluidHandler((ItemStack)stack).filter(item -> {
            for (int i = 0; i < item.getTanks(); ++i) {
                if (item.getFluidInTank(i).isEmpty()) continue;
                return false;
            }
            return true;
        }).isPresent();
    }

    public static boolean isRoomInContainer(ItemStack stack, Fluid fluid) {
        return FluidUtil.getFluidHandler((ItemStack)stack).filter(item -> item.fill(new FluidStack(fluid, Integer.MAX_VALUE), IFluidHandler.FluidAction.SIMULATE) > 0).isPresent();
    }

    public static boolean containsFluid(ItemStack stack, Fluid fluid) {
        return FluidUtil.getFluidHandler((ItemStack)stack).filter(item -> {
            for (int i = 0; i < item.getTanks(); ++i) {
                if (item.getFluidInTank(i).getFluid().isSame(fluid)) continue;
                return false;
            }
            return true;
        }).isPresent();
    }

    private static void sendToProcessing(Container container) {
        ContainerMapper.make(container, 0, 1).moveOneItemTo(ContainerMapper.make(container, 1, 1).ignoreItemChecks());
    }

    private static void sendToOutput(Container container) {
        ContainerMapper.make(container, 1, 1).moveOneItemTo(ContainerMapper.make(container, 2, 1).ignoreItemChecks());
    }

    private static ProcessState tryFill(Container container, StandardTank tank, ItemStack itemStack) {
        FluidActionResult result = FluidUtil.tryFillContainer((ItemStack)itemStack, (IFluidHandler)tank, (int)1000, null, (boolean)true);
        if (!result.isSuccess()) {
            FluidTools.sendToOutput(container);
            return ProcessState.RESET;
        }
        container.setItem(1, result.getResult());
        return ProcessState.FILLING;
    }

    private static ProcessState tryDrain(Container container, StandardTank tank, ItemStack itemStack) {
        FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)itemStack, (IFluidHandler)tank, (int)1000, null, (boolean)true);
        if (!result.isSuccess()) {
            FluidTools.sendToOutput(container);
            return ProcessState.RESET;
        }
        container.setItem(1, result.getResult());
        return ProcessState.DRAINING;
    }

    public static ProcessState processContainer(Container container, StandardTank tank, ProcessType type, ProcessState state) {
        ItemStack itemStack = container.getItem(1);
        if (itemStack.isEmpty() || !FluidTools.isFluidHandler(itemStack)) {
            FluidTools.sendToProcessing(container);
            return ProcessState.RESET;
        }
        if (state == ProcessState.RESET) {
            if (type == ProcessType.FILL_ONLY) {
                return FluidTools.tryFill(container, tank, itemStack);
            }
            if (type == ProcessType.DRAIN_ONLY) {
                return FluidTools.tryDrain(container, tank, itemStack);
            }
            if (type == ProcessType.FILL_THEN_DRAIN) {
                if (FluidUtil.tryFillContainer((ItemStack)itemStack, (IFluidHandler)tank, (int)1000, null, (boolean)false).isSuccess()) {
                    return FluidTools.tryFill(container, tank, itemStack);
                }
                return FluidTools.tryDrain(container, tank, itemStack);
            }
            if (type == ProcessType.DRAIN_THEN_FILL) {
                if (FluidUtil.getFluidContained((ItemStack)itemStack).isPresent() && !tank.isFull()) {
                    return FluidTools.tryDrain(container, tank, itemStack);
                }
                return FluidTools.tryFill(container, tank, itemStack);
            }
        }
        if (state == ProcessState.FILLING) {
            return FluidTools.tryFill(container, tank, itemStack);
        }
        if (state == ProcessState.DRAINING) {
            return FluidTools.tryDrain(container, tank, itemStack);
        }
        return state;
    }

    public static boolean isFullFluidBlock(Level level, BlockPos pos) {
        return FluidTools.isFullFluidBlock(level.getBlockState(pos), level, pos);
    }

    public static boolean isFullFluidBlock(BlockState state, Level level, BlockPos pos) {
        if (state.getBlock() instanceof LiquidBlock) {
            return (Integer)state.getValue((Property)LiquidBlock.LEVEL) == 0;
        }
        return false;
    }

    public static Fluid getFluid(BlockState state) {
        return state.getFluidState().getType();
    }

    public static Collection<IFluidHandler> findNeighbors(Level level, BlockPos centrePos, Predicate<BlockEntity> filter, Direction ... directions) {
        ArrayList<IFluidHandler> targets = new ArrayList<IFluidHandler>();
        for (Direction direction : directions) {
            IFluidHandler cap;
            BlockEntity blockEntity = level.getBlockEntity(centrePos.relative(direction));
            if (blockEntity == null || !TankManager.TANK_FILTER.apply(blockEntity, direction.getOpposite()).booleanValue() || !filter.test(blockEntity) || (cap = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, blockEntity.getBlockPos(), (Object)direction.getOpposite())) == null) continue;
            targets.add(cap);
        }
        return targets;
    }

    public static enum ProcessState implements StringRepresentable
    {
        FILLING("filling"),
        DRAINING("draining"),
        RESET("reset");

        private static final StringRepresentable.EnumCodec<ProcessState> CODEC;
        private final String name;

        private ProcessState(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }

        public static ProcessState fromName(String name) {
            return (ProcessState)CODEC.byName(name, (Enum)RESET);
        }

        public static ProcessState fromTag(CompoundTag tag) {
            return ProcessState.fromName(tag.getString("processState"));
        }

        static {
            CODEC = StringRepresentable.fromEnum(ProcessState::values);
        }
    }

    public static enum ProcessType {
        FILL_ONLY,
        DRAIN_ONLY,
        FILL_THEN_DRAIN,
        DRAIN_THEN_FILL;

    }
}

