/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.entity.vehicle;

import java.util.List;
import mods.railcraft.RailcraftConfig;
import mods.railcraft.api.carts.RollingStock;
import mods.railcraft.api.track.TrackUtil;
import mods.railcraft.util.EntitySearcher;
import mods.railcraft.util.ModEntitySelector;
import mods.railcraft.world.entity.vehicle.TunnelBore;
import mods.railcraft.world.level.block.RailcraftBlocks;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.IMinecartCollisionHandler;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;
import org.joml.Vector2dc;

public class MinecartHandler
implements IMinecartCollisionHandler {
    private static final float OPTIMAL_DISTANCE = 1.28f;
    private static final float COEF_SPRING = 0.2f;
    private static final float COEF_SPRING_PLAYER = 0.5f;
    private static final float COEF_RESTITUTION = 0.2f;
    private static final float COEF_DAMPING = 0.4f;
    private static final float CART_LENGTH = 1.22f;
    private static final float CART_WIDTH = 0.98f;
    private static final float COLLISION_EXPANSION = 0.2f;
    private static final int MAX_INTERACT_DIST_SQ = 25;

    public void onEntityCollision(AbstractMinecart cart, Entity other) {
        Player otherPlayer;
        Level level = cart.level();
        if (level.isClientSide() || cart.hasPassenger(other) || !other.isAlive() || !cart.isAlive()) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        RollingStock rollingStock = RollingStock.getOrThrow(cart);
        AbstractMinecart link = rollingStock.backLink().map(RollingStock::entity).orElse(null);
        if (link != null && (link == other || link.hasPassenger(other))) {
            return;
        }
        link = rollingStock.frontLink().map(RollingStock::entity).orElse(null);
        if (link != null && (link == other || link.hasPassenger(other))) {
            return;
        }
        boolean isLiving = other instanceof LivingEntity;
        boolean isPlayer = other instanceof Player;
        if (other instanceof Player && (otherPlayer = (Player)other).isSpectator()) {
            return;
        }
        if (other instanceof AbstractMinecart) {
            AbstractMinecart otherCart = (AbstractMinecart)other;
            rollingStock.tryAutoLink(RollingStock.getOrThrow(otherCart));
        }
        this.testHighSpeedCollision(rollingStock, other);
        if (isLiving && level.getBlockState(cart.blockPosition()).is((Block)RailcraftBlocks.ELEVATOR_TRACK.get()) && other.getBoundingBox().minY < cart.getBoundingBox().maxY) {
            other.move(MoverType.SELF, new Vec3(0.0, cart.getBoundingBox().maxY - other.getBoundingBox().minY, 0.0));
            other.setOnGround(true);
        }
        if (level.getRandom().nextFloat() < 0.001f) {
            List<AbstractMinecart> carts = EntitySearcher.findMinecarts().around((Entity)cart).and(EntitySelector.ENTITY_STILL_ALIVE, ModEntitySelector.NON_MECHANICAL).list(level);
            int maxEntityCramming = serverLevel.getGameRules().getInt(GameRules.RULE_MAX_ENTITY_CRAMMING);
            if (carts.size() >= maxEntityCramming) {
                rollingStock.primeExplosion();
            }
        }
        Vec3 cartMotion = cart.getDeltaMovement();
        if (isLiving && !isPlayer && cart.canBeRidden() && !(other instanceof IronGolem) && cartMotion.x() * cartMotion.x() + cartMotion.z() * cartMotion.z() > 0.001 && !cart.isVehicle() && !other.isPassenger() && rollingStock.isMountable()) {
            other.startRiding((Entity)cart);
        }
        if (isLiving && level.getBlockState(cart.blockPosition()).is((Block)RailcraftBlocks.ELEVATOR_TRACK.get())) {
            return;
        }
        Vector2d sub = new Vector2d(other.getX(), other.getZ()).sub(cart.getX(), cart.getZ());
        Vector2d unit = sub.equals(0.0, 0.0) ? sub : sub.normalize();
        double distance = cart.distanceTo(other);
        double depth = distance - (double)1.28f;
        double forceX = 0.0;
        double forceZ = 0.0;
        if (depth < 0.0) {
            double spring = isPlayer ? 0.5 : (double)0.2f;
            double penaltyX = spring * depth * unit.x();
            double penaltyZ = spring * depth * unit.y();
            forceX += penaltyX;
            forceZ += penaltyZ;
            if (!isPlayer) {
                double impulseX = unit.x();
                double impulseZ = unit.y();
                impulseX *= -1.2000000029802322;
                impulseZ *= -1.2000000029802322;
                Vector2d cartVel = new Vector2d(cart.getDeltaMovement().x(), cart.getDeltaMovement().z());
                Vector2d otherVel = new Vector2d(other.getDeltaMovement().x(), other.getDeltaMovement().z());
                double dot = otherVel.sub((Vector2dc)cartVel).dot((Vector2dc)unit);
                impulseX *= dot;
                impulseZ *= dot;
                forceX -= (impulseX *= 0.5);
                forceZ -= (impulseZ *= 0.5);
            }
        }
        if (other instanceof AbstractMinecart) {
            AbstractMinecart otherCart = (AbstractMinecart)other;
            if (!(cart.isPoweredCart() && !otherCart.isPoweredCart() || TrackUtil.isCartLocked(cart))) {
                cart.setDeltaMovement(cart.getDeltaMovement().add(forceX, 0.0, forceZ));
            }
            if (!(otherCart.isPoweredCart() && !cart.isPoweredCart() || TrackUtil.isCartLocked(otherCart))) {
                other.setDeltaMovement(other.getDeltaMovement().add(-forceX, 0.0, -forceZ));
            }
        } else {
            Vector2d cartVel = new Vector2d(cart.getDeltaMovement().x(), cart.getDeltaMovement().z()).add(forceX, forceZ);
            Vector2d otherVel = new Vector2d(other.getDeltaMovement().x(), other.getDeltaMovement().z()).sub(forceX, forceZ);
            double dot = otherVel.sub((Vector2dc)cartVel).dot((Vector2dc)unit);
            double dampX = (double)0.4f * dot * unit.x();
            double dampZ = (double)0.4f * dot * unit.y();
            forceX += dampX;
            forceZ += dampZ;
            if (!isPlayer) {
                other.setDeltaMovement(other.getDeltaMovement().add(-forceX, 0.0, -forceZ));
            }
            if (!TrackUtil.isCartLocked(cart)) {
                cart.setDeltaMovement(cart.getDeltaMovement().add(forceX, 0.0, forceZ));
            }
        }
    }

    private void testHighSpeedCollision(RollingStock rollingStock, Entity other) {
        AbstractMinecart cart = rollingStock.entity();
        if (rollingStock.isHighSpeed()) {
            boolean otherHighSpeed;
            RollingStock otherExtension;
            if (other instanceof AbstractMinecart) {
                AbstractMinecart otherCart = (AbstractMinecart)other;
                v0 = RollingStock.getOrThrow(otherCart);
            } else {
                v0 = otherExtension = null;
            }
            if (otherExtension != null && rollingStock.isSameTrainAs(otherExtension)) {
                return;
            }
            if (rollingStock.train().entities().anyMatch(c -> c.hasPassenger(other))) {
                return;
            }
            if (otherExtension != null && (!(otherHighSpeed = otherExtension.isHighSpeed()) || cart.getDeltaMovement().x() > 0.0 ^ other.getDeltaMovement().x() > 0.0 || cart.getDeltaMovement().z() > 0.0 ^ other.getDeltaMovement().z() > 0.0)) {
                rollingStock.primeExplosion();
                return;
            }
            if (!other.isAlive() || ((List)RailcraftConfig.SERVER.highSpeedTrackIgnoredEntities.get()).contains(BuiltInRegistries.ENTITY_TYPE.getKey((Object)other.getType()).toString())) {
                return;
            }
            rollingStock.primeExplosion();
        }
    }

    @Nullable
    public AABB getCollisionBox(AbstractMinecart cart, Entity other) {
        if (other instanceof ItemEntity && ((Boolean)RailcraftConfig.SERVER.cartsCollideWithItems.get()).booleanValue()) {
            return other.getBoundingBox().inflate(-0.01);
        }
        return other.isPushable() ? other.getBoundingBox().inflate((double)-0.2f) : null;
    }

    public AABB getMinecartCollisionBox(AbstractMinecart cart) {
        double yaw = Math.toRadians(cart.getYRot());
        double diff = 0.3200000077486038;
        double x = diff * Math.abs(Math.cos(yaw));
        double z = diff * Math.abs(Math.sin(yaw));
        return cart.getBoundingBox().inflate(x, (double)0.2f, z);
    }

    @Nullable
    public AABB getBoundingBox(AbstractMinecart cart) {
        if (cart == null || !cart.isAlive()) {
            return null;
        }
        if (((Boolean)RailcraftConfig.SERVER.solidCarts.get()).booleanValue()) {
            return cart.getBoundingBox();
        }
        return null;
    }

    public boolean handleInteract(AbstractMinecart cart, Player player) {
        if (!(cart instanceof TunnelBore) && player.distanceToSqr((Entity)cart) > 25.0) {
            return true;
        }
        if (!cart.isAlive()) {
            return true;
        }
        if (cart.canBeRidden()) {
            if (player.getVehicle() != null && player.getVehicle() != cart) {
                return true;
            }
            if (player.getVehicle() != cart && player.onClimbable()) {
                return true;
            }
        }
        return !player.hasLineOfSight((Entity)cart);
    }
}

