/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.entity.vehicle;

import mods.railcraft.api.track.RailShapeUtil;
import mods.railcraft.tags.RailcraftTags;
import mods.railcraft.util.container.ContainerTools;
import mods.railcraft.world.entity.RailcraftEntityTypes;
import mods.railcraft.world.entity.vehicle.MaintenanceMinecart;
import mods.railcraft.world.entity.vehicle.MaintenancePatternMinecart;
import mods.railcraft.world.inventory.TrackLayerMenu;
import mods.railcraft.world.item.RailcraftItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.neoforged.neoforge.common.IShearable;
import net.neoforged.neoforge.common.SpecialPlantable;

public class TrackLayer
extends MaintenancePatternMinecart {
    private static final int SLOT_STOCK = 0;
    private static final int SLOT_REPLACE = 0;
    private static final int[] SLOTS = ContainerTools.buildSlotArray(0, 1);

    public TrackLayer(EntityType<?> type, Level level) {
        super(type, level);
    }

    public TrackLayer(ItemStack itemStack, double x, double y, double z, ServerLevel level) {
        super(itemStack, (EntityType)RailcraftEntityTypes.TRACK_LAYER.get(), x, y, z, (Level)level);
    }

    @Override
    protected Item getDropItem() {
        return (Item)RailcraftItems.TRACK_LAYER.get();
    }

    protected void moveAlongTrack(BlockPos pos, BlockState state) {
        super.moveAlongTrack(pos, state);
        if (this.level().isClientSide()) {
            return;
        }
        this.stockItems(0, 0);
        this.updateTravelDirection(pos, state);
        this.travelDirection().ifPresent(direction -> this.placeTrack(pos, (Direction)direction));
    }

    private void placeTrack(BlockPos pos, Direction direction) {
        if (this.mode() == MaintenanceMinecart.Mode.OFF) {
            return;
        }
        pos = pos.relative(direction);
        RailShape railShape = RailShape.NORTH_SOUTH;
        if (direction == Direction.EAST || direction == Direction.WEST) {
            railShape = RailShape.EAST_WEST;
        }
        if (!this.isValidReplacementBlock(pos) && this.isValidReplacementBlock(pos.above()) && !RailShapeUtil.isTurn(railShape)) {
            pos = pos.above();
        }
        if (this.isValidReplacementBlock(pos) && this.isValidReplacementBlock(pos.below())) {
            pos = pos.below();
            railShape = switch (direction) {
                case Direction.NORTH -> RailShape.ASCENDING_SOUTH;
                case Direction.SOUTH -> RailShape.ASCENDING_NORTH;
                case Direction.WEST -> RailShape.ASCENDING_WEST;
                case Direction.EAST -> RailShape.ASCENDING_EAST;
                default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf(direction));
            };
        }
        if (this.isValidNewTrackPosition(pos)) {
            BlockState targetState = this.level().getBlockState(pos);
            if (this.placeNewTrack(pos, 0, railShape)) {
                Block.dropResources((BlockState)targetState, (Level)this.level(), (BlockPos)pos);
            }
        }
    }

    private boolean isValidNewTrackPosition(BlockPos pos) {
        return this.isValidReplacementBlock(pos) && Block.canSupportRigidBlock((BlockGetter)this.level(), (BlockPos)pos.below());
    }

    private boolean isValidReplacementBlock(BlockPos pos) {
        BlockState state = this.level().getBlockState(pos);
        Block block = state.getBlock();
        return state.isAir() || block instanceof SpecialPlantable || block instanceof IShearable || state.is(RailcraftTags.Blocks.TUNNEL_BORE_REPLACEABLE_BLOCKS);
    }

    public int[] getSlotsForFace(Direction side) {
        return SLOTS;
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        ItemStack trackReplace = this.patternContainer.getItem(0);
        return ItemStack.isSameItem((ItemStack)stack, (ItemStack)trackReplace);
    }

    protected AbstractContainerMenu createMenu(int id, Inventory inventory) {
        return new TrackLayerMenu(id, inventory, this);
    }
}

