/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item;

import java.util.List;
import mods.railcraft.Translations;
import mods.railcraft.world.item.FirestoneItem;
import mods.railcraft.world.level.block.RailcraftBlocks;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class FirestoneOreBlockItem
extends BlockItem {
    public FirestoneOreBlockItem(Item.Properties properties) {
        super((Block)RailcraftBlocks.FIRESTONE_ORE.get(), properties);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (level.getGameRules().getBoolean(GameRules.RULE_DOFIRETICK) && entity instanceof Player) {
                Player player = (Player)entity;
                if (level.getRandom().nextInt(12) % 4 == 0) {
                    FirestoneItem.trySpawnFire(serverLevel, player.blockPosition(), stack, (Entity)player);
                }
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)Translations.Tips.FIRESTONE_ORE).withStyle(ChatFormatting.GRAY));
    }
}

