/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item.crafting;

import java.util.function.Predicate;
import java.util.stream.IntStream;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.item.component.RailcraftDataComponents;
import mods.railcraft.world.item.component.TicketComponent;
import mods.railcraft.world.item.crafting.RailcraftRecipeSerializers;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class TicketDuplicateRecipe
extends CustomRecipe {
    private static final Ingredient SOURCE = Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RailcraftItems.GOLDEN_TICKET.get()});
    private static final Ingredient BLANK = Ingredient.of((ItemLike[])new ItemLike[]{Items.PAPER});

    public TicketDuplicateRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput craftingInput, Level level) {
        int numBlank = 0;
        int numSource = 0;
        for (int slot = 0; slot < craftingInput.size(); ++slot) {
            ItemStack stack = craftingInput.getItem(slot);
            if (stack.isEmpty()) continue;
            if (numSource == 0 && SOURCE.test(stack)) {
                ++numSource;
                continue;
            }
            if (BLANK.test(stack)) {
                ++numBlank;
                continue;
            }
            return false;
        }
        return numSource == 1 && numBlank == 1;
    }

    public ItemStack assemble(CraftingInput craftingInput, HolderLookup.Provider provider) {
        ItemStack source = IntStream.range(0, craftingInput.size()).mapToObj(arg_0 -> ((CraftingInput)craftingInput).getItem(arg_0)).filter((Predicate<ItemStack>)SOURCE).findFirst().orElse(ItemStack.EMPTY);
        ItemStack result = this.getResultItem(provider);
        if (!source.isEmpty() && source.has(RailcraftDataComponents.TICKET)) {
            result.set(RailcraftDataComponents.TICKET, (Object)((TicketComponent)source.get(RailcraftDataComponents.TICKET)));
        }
        return result;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList ingredients = NonNullList.create();
        ingredients.add((Object)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)RailcraftItems.GOLDEN_TICKET.get()}));
        ingredients.add((Object)Ingredient.of((ItemLike[])new ItemLike[]{Items.PAPER}));
        return ingredients;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return new ItemStack((ItemLike)RailcraftItems.TICKET.get());
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)RailcraftRecipeSerializers.TICKET_DUPLICATE.get();
    }
}

