/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.tank;

import mods.railcraft.world.level.block.tank.BaseTankBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class TankValveBlock
extends BaseTankBlock {
    public static final Property<Direction.Axis> AXIS = BlockStateProperties.AXIS;

    protected TankValveBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(AXIS, (Comparable)Direction.Axis.Y));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AXIS});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)TankValveBlock.determineAxis(context.getLevel(), context.getClickedPos(), context.getClickedFace().getAxis()));
    }

    public void neighborChanged(BlockState blockState, Level level, BlockPos blockPos, Block neighborBlock, BlockPos neighborPos, boolean moved) {
        super.neighborChanged(blockState, level, blockPos, neighborBlock, neighborPos, moved);
        Direction.Axis currentAxis = (Direction.Axis)blockState.getValue(AXIS);
        Direction.Axis axis = TankValveBlock.determineAxis(level, blockPos, currentAxis);
        if (axis != currentAxis) {
            level.setBlockAndUpdate(blockPos, (BlockState)blockState.setValue(AXIS, (Comparable)axis));
        }
    }

    private static Direction.Axis determineAxis(Level level, BlockPos blockPos, Direction.Axis fallback) {
        for (Direction direction : Direction.values()) {
            if (!level.getBlockState(blockPos.relative(direction)).isAir()) continue;
            return direction.getAxis();
        }
        return fallback;
    }
}

