/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.module;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import mods.railcraft.api.charge.Charge;
import mods.railcraft.api.charge.ChargeStorage;
import mods.railcraft.util.ForwardingEnergyStorage;
import mods.railcraft.util.container.AdvancedContainer;
import mods.railcraft.util.container.ContainerMapper;
import mods.railcraft.world.item.crafting.CrusherRecipe;
import mods.railcraft.world.item.crafting.RailcraftRecipeTypes;
import mods.railcraft.world.level.block.entity.CrusherBlockEntity;
import mods.railcraft.world.module.CrafterModule;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;

public class CrusherModule
extends CrafterModule<CrusherBlockEntity> {
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_OUTPUT = 9;
    private static final int COST_PER_TICK = 80;
    private static final int COST_PER_STEP = 1280;
    private final ContainerMapper inputContainer;
    private final ContainerMapper outputContainer;
    private final RandomSource random = RandomSource.create();
    private final Charge network;
    private Optional<RecipeHolder<CrusherRecipe>> currentRecipe;
    private int currentSlot;
    private final IItemHandler itemHandler;
    private final IEnergyStorage energyHandler;

    public CrusherModule(CrusherBlockEntity provider, Charge network) {
        super(provider, 18);
        this.network = network;
        this.inputContainer = ContainerMapper.make(this, 0, 9);
        this.outputContainer = ContainerMapper.make(this, 9, 9).ignoreItemChecks();
        this.currentRecipe = Optional.empty();
        this.itemHandler = new InvWrapper(this, this){

            @NotNull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (slot < 9) {
                    return ItemStack.EMPTY;
                }
                return super.extractItem(slot, amount, simulate);
            }

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                if (slot < 9) {
                    return super.insertItem(slot, stack, simulate);
                }
                return stack;
            }
        };
        this.energyHandler = new ForwardingEnergyStorage(this::storage);
    }

    public Optional<? extends ChargeStorage> storage() {
        return ((CrusherBlockEntity)this.provider).level().isClientSide() ? Optional.empty() : this.access().storage();
    }

    private Charge.Access access() {
        return this.network.network((ServerLevel)((CrusherBlockEntity)this.provider).level()).access(((CrusherBlockEntity)this.provider).blockPos());
    }

    @Override
    public void serverTick() {
        super.serverTick();
        if (!this.lacksRequirements()) {
            this.energyHandler.extractEnergy(80, false);
        }
    }

    @Override
    public boolean canPlaceItem(int index, ItemStack stack) {
        if (index < 9 && super.canPlaceItem(index, stack)) {
            return this.getRecipe(stack).isPresent();
        }
        return true;
    }

    @Override
    protected int calculateDuration() {
        return this.currentRecipe.map(RecipeHolder::value).map(CrusherRecipe::getProcessTime).orElse(200);
    }

    @Override
    protected boolean lacksRequirements() {
        return this.currentRecipe.isEmpty();
    }

    @Override
    protected boolean doProcessStep() {
        return this.energyHandler.getEnergyStored() > 1280;
    }

    @Override
    protected void setupCrafting() {
        if (this.isRecipeValid()) {
            return;
        }
        this.currentRecipe = Optional.empty();
        for (int i = 0; i < this.inputContainer.getContainerSize(); ++i) {
            ItemStack itemStack = this.inputContainer.getItem(i);
            if (itemStack.isEmpty()) continue;
            this.currentSlot = i;
            this.currentRecipe = this.getRecipe(itemStack);
            break;
        }
    }

    private List<ItemStack> pollOutputs(CrusherRecipe recipe) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (CrusherRecipe.CrusherOutput item : recipe.getProbabilityOutputs()) {
            if (!(this.random.nextDouble() < item.probability())) continue;
            result.add(item.getOutput());
        }
        return result;
    }

    @Override
    protected boolean craftAndPush() {
        CrusherRecipe recipe = this.currentRecipe.map(RecipeHolder::value).orElseThrow(NullPointerException::new);
        AdvancedContainer tempInv = AdvancedContainer.copyOf(this.outputContainer);
        List<ItemStack> outputs = this.pollOutputs(recipe);
        boolean hasSpace = outputs.stream().map(tempInv::insert).allMatch(ItemStack::isEmpty);
        if (hasSpace) {
            outputs.forEach(this.outputContainer::insert);
            this.inputContainer.extract((Predicate)recipe.getIngredients().getFirst());
            ((CrusherBlockEntity)this.provider).getLevel().playSound(null, ((CrusherBlockEntity)this.provider).blockPos(), SoundEvents.IRON_GOLEM_DEATH, SoundSource.BLOCKS, 1.0f, ((CrusherBlockEntity)this.provider).getLevel().getRandom().nextFloat() * 0.25f + 0.7f);
        }
        return hasSpace;
    }

    private boolean isRecipeValid() {
        return this.currentRecipe.map(RecipeHolder::value).map(r -> (Ingredient)r.getIngredients().getFirst()).map(r -> r.test(this.inputContainer.getItem(this.currentSlot))).orElse(false);
    }

    private Optional<RecipeHolder<CrusherRecipe>> getRecipe(ItemStack itemStack) {
        return ((CrusherBlockEntity)this.provider).getLevel().getRecipeManager().getRecipeFor((RecipeType)RailcraftRecipeTypes.CRUSHING.get(), (RecipeInput)new SingleRecipeInput(itemStack), ((CrusherBlockEntity)this.provider).getLevel());
    }

    @Override
    public void setChanged() {
        super.setChanged();
        this.currentRecipe = Optional.empty();
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public IEnergyStorage getEnergyHandler() {
        return this.energyHandler;
    }
}

