/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.entity.ai.spell;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.entity.ai.spell.AbstractOffensiveSpellGoal;

public class ThunderSpellGoal
extends AbstractOffensiveSpellGoal {
    public ThunderSpellGoal(PathfinderMob caster) {
        super(caster);
    }

    @Override
    protected void performSpellCasting() {
        LightningBolt bolt;
        @Nullable LivingEntity entity = this.caster.getTarget();
        if (entity != null && entity.isAlive() && (bolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(this.caster.level())) != null) {
            bolt.moveTo(entity.position());
            bolt.setVisualOnly(false);
            this.caster.level().addFreshEntity((Entity)bolt);
        }
    }

    @Override
    protected int getCastWarmupTime() {
        return 40;
    }

    @Override
    protected int getCastingTime() {
        return 60;
    }

    @Override
    protected int getCastingInterval() {
        return 400;
    }

    @Override
    @Nullable
    protected SoundEvent getSpellPrepareSound() {
        return (SoundEvent)SoundEvents.TRIDENT_THUNDER.value();
    }

    @Override
    protected int getSpellColor() {
        return 0x202080;
    }
}

