/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public final class GlobalClock
extends SavedData {
    public static final GlobalClock INSTANCE = new GlobalClock();
    private long serverTime = 0L;
    private long clientTime = 0L;
    private static final SavedData.Factory<GlobalClock> FACTORY = new SavedData.Factory(() -> INSTANCE, GlobalClock::load);

    private static GlobalClock load(CompoundTag tag, HolderLookup.Provider registries) {
        GlobalClock.INSTANCE.serverTime = tag.getLong("time");
        return INSTANCE;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
        tag.putLong("time", this.serverTime);
        return tag;
    }

    public void clientTick() {
        ++this.clientTime;
    }

    public void serverTick() {
        ++this.serverTime;
        this.setDirty();
    }

    public void setClientTime(long clientTime) {
        this.clientTime = clientTime;
    }

    public long getTime(Level level) {
        return level.isClientSide() ? this.clientTime : this.getTime(level.getServer());
    }

    public long getTime(MinecraftServer server) {
        return ((GlobalClock)server.overworld().getDataStorage().computeIfAbsent(GlobalClock.FACTORY, (String)"tb_global_clock")).serverTime;
    }
}

