/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.api.item.ISoulConsumer;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.GlobalClock;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.helper.VanillaStructures;
import ovh.corail.tombstone.helper.WorldHelper;
import ovh.corail.tombstone.item.ItemGraveMagic;
import ovh.corail.tombstone.registry.ModDataComponents;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModPerks;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemLostTablet
extends ItemGraveMagic {
    public ItemLostTablet() {
        super("lost_tablet", () -> SharedConfigTombstone.allowed_magic_items.allowLostTablet.get());
    }

    @Override
    protected void addTooltipInfo(ItemStack stack, Item.TooltipContext context, List<Component> tooltip) {
        Type type = this.getType(stack);
        String id = type.isUnknown() ? "1" : (this.isEnchanted(stack) ? "3" : "2");
        this.addItemDesc(tooltip, id, new Object[0]);
        if (!type.isUnknown()) {
            this.getLocationId(stack).ifPresent(rl -> tooltip.add(type == Type.EXPLORATION ? WorldHelper.getBiomeName(rl) : WorldHelper.getStructureName(rl)));
            this.addItemPosition(tooltip, this.getLocation(stack));
        }
        this.addItemUse(tooltip, id, new Object[0]);
        super.addTooltipInfo(stack, context, tooltip);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (stack.is((Item)this) && EntityHelper.isValidServerPlayer(entity) && !this.isWakeUp(stack)) {
            int cd;
            ServerPlayer player = (ServerPlayer)entity;
            int roll = ((Short)stack.getOrDefault(ModDataComponents.LOST_TABLET_ROLL_NO_SYNC, (Object)-1)).shortValue();
            if (roll == -1) {
                roll = Helper.RANDOM.nextInt(100) + EntityHelper.getPerkLevelWithBonus((Player)player, ModPerks.archaeologist) * 10;
                stack.set(ModDataComponents.LOST_TABLET_ROLL_NO_SYNC, (Object)((short)roll));
            }
            if ((cd = this.getWakeUpCooldown(level, stack)) <= 0) {
                this.setWakeUpCooldown(level, stack, TimeHelper.tickFromSecond(500 + Helper.RANDOM.nextInt(301)));
            } else if (cd == 1) {
                if (this.wakeUpMagic(player, stack, Type.get(roll))) {
                    LangKey.MESSAGE_LOST_TABLET_WAKE_UP_SUCCESS.sendMessage((Player)player, StyleType.MESSAGE_SPELL, new Object[0]);
                } else if (Helper.RANDOM.nextInt(5) != 0) {
                    this.setWakeUpCooldown(level, stack, TimeHelper.tickFromSecond(1500 + Helper.RANDOM.nextInt(301)));
                } else {
                    LangKey.MESSAGE_LOST_TABLET_WAKE_UP_FAILED.sendMessage((Player)player, StyleType.MESSAGE_SPELL, new Object[0]);
                    stack.shrink(1);
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)ModItems.grave_dust, Helper.RANDOM.nextInt(4) + 2));
                    player.inventoryMenu.broadcastChanges();
                    ModTriggers.grave_dust_from_breaking_tablet.trigger(player);
                }
            }
        }
    }

    public int getWakeUpCooldown(Level level, ItemStack stack) {
        return ModDataComponents.getTimer(GlobalClock.INSTANCE.getTime(level), stack, ModDataComponents.COOLDOWN_TIME_NO_SYNC, TimeHelper.tickFromSecond(1800));
    }

    public void setWakeUpCooldown(Level level, ItemStack stack, int time) {
        if (stack.is((Item)this)) {
            stack.set(ModDataComponents.COOLDOWN_TIME_NO_SYNC, (Object)(GlobalClock.INSTANCE.getTime(level) + (long)time));
        }
    }

    private boolean wakeUpMagic(ServerPlayer player, ItemStack stack, Type type) {
        ResourceLocation structureRL;
        Location location;
        ServerLevel level = player.serverLevel();
        if (type == Type.EXPLORATION) {
            location = new Location(WorldHelper.getCloserValidPos((Level)level, player.blockPosition().offset((int)(Helper.RANDOM.nextGaussian() * 5000.0 + 500.0), 0, (int)(Helper.RANDOM.nextGaussian() * 5000.0 + 500.0))), (Level)level);
            structureRL = level.getBiome(location.getPos()).unwrapKey().map(ResourceKey::location).orElse(null);
        } else {
            HolderSet<Structure> holderSet;
            if (type == Type.VILLAGE) {
                holderSet = VanillaStructures.VILLAGE.asHolderSet(level);
            } else {
                holderSet = (Boolean)ConfigTombstone.magic_item.lostTabletSearchModdedStructure.get() != false ? WorldHelper.getRandomStructure(level, rl -> !VanillaStructures.VILLAGE.is((ResourceLocation)rl) && !Helper.containRL((List)ConfigTombstone.magic_item.lostTabletDeniedStructures.get(), rl)) : VanillaStructures.getRandomStructure(level, vanillaStructure -> vanillaStructure != VanillaStructures.VILLAGE);
                if (holderSet == null) {
                    type = Type.VILLAGE;
                    holderSet = VanillaStructures.VILLAGE.asHolderSet(level);
                }
            }
            Optional structureHolder = holderSet.getRandomElement(Helper.RANDOM_SOURCE);
            HolderSet biomes = structureHolder.map(Holder::value).map(Structure::biomes).orElse(null);
            ResourceLocation rl2 = structureHolder.map(Holder::unwrapKey).filter(Optional::isPresent).map(Optional::get).map(ResourceKey::location).orElse(null);
            if (biomes == null || rl2 == null) {
                return false;
            }
            if (((Boolean)ConfigTombstone.magic_item.lostTabletSearchOutsideWorld.get()).booleanValue() && (!WorldHelper.hasStructureInWorld(level, rl2, (HolderSet<Biome>)biomes) || Helper.RANDOM.nextFloat() < 0.3f)) {
                level = Helper.getRandomInList(this.getPossibleWorlds(level.getServer(), rl2, (HolderSet<Biome>)biomes)).orElse(level);
            }
            Pair<Location, ResourceLocation> res = WorldHelper.findNearestStructure(level, player.blockPosition().offset((int)(Helper.RANDOM.nextGaussian() * 2000.0), 0, (int)(Helper.RANDOM.nextGaussian() * 2000.0)), holderSet, true);
            location = (Location)res.getLeft();
            structureRL = (ResourceLocation)res.getRight();
        }
        if (structureRL == null || location.isOrigin() || !WorldHelper.isValidPos((Level)level, location.getPos())) {
            return false;
        }
        stack.set(ModDataComponents.LOST_TABLET_TYPE, (Object)((short)type.ordinal()));
        stack.set(ModDataComponents.LOST_TABLET_ID, (Object)structureRL.toString());
        ModDataComponents.setLocation(stack, location);
        stack.remove(ModDataComponents.LOST_TABLET_ROLL_NO_SYNC);
        switch (type.ordinal()) {
            case 1: {
                ModTriggers.find_lost_tablet_exploration.trigger(player);
                break;
            }
            case 2: {
                ModTriggers.find_lost_tablet_village.trigger(player);
                break;
            }
            case 3: {
                ModTriggers.find_lost_tablet_treasure.trigger(player);
            }
        }
        return true;
    }

    private List<ServerLevel> getPossibleWorlds(MinecraftServer server, ResourceLocation structureRL, HolderSet<Biome> structureBiomes) {
        Predicate<ServerLevel> predic = world -> true;
        if (SupportMods.CHUNKBYCHUNK.isLoaded()) {
            predic = world -> {
                ResourceLocation rl = world.dimension().location();
                return !rl.getNamespace().equals("chunkbychunk") && !rl.getNamespace().equals("overworld") && (!rl.getPath().startsWith("overworld_") || !rl.getPath().endsWith("_gen"));
            };
        }
        if (!((List)ConfigTombstone.magic_item.lostTabletDeniedWorlds.get()).isEmpty()) {
            predic = world -> {
                ResourceLocation rl = world.dimension().location();
                return !Helper.containRL((List)ConfigTombstone.magic_item.lostTabletDeniedWorlds.get(), rl);
            };
        }
        return StreamSupport.stream(server.getAllLevels().spliterator(), false).filter(predic).filter(level -> WorldHelper.hasStructureInWorld(level, structureRL, structureBiomes)).collect(Collectors.toList());
    }

    public Optional<String> getLocationId(ItemStack stack) {
        String id;
        if (stack.is((Item)this) && !(id = (String)stack.getOrDefault(ModDataComponents.LOST_TABLET_ID, (Object)"")).isEmpty()) {
            return Optional.of(id);
        }
        return Optional.empty();
    }

    public boolean isWakeUp(ItemStack stack) {
        return stack.is((Item)this) && !this.getType(stack).isUnknown();
    }

    @Override
    public boolean canEnchant(Level level, BlockPos gravePos, Player player, ItemStack stack) {
        return super.canEnchant(level, gravePos, player, stack) && this.isWakeUp(stack);
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return this.isWakeUp(stack) && (Boolean)stack.getOrDefault(ModDataComponents.ENCHANTED, (Object)false) != false;
    }

    @Override
    public boolean isFoil(ItemStack stack) {
        return (Boolean)stack.getOrDefault(ModDataComponents.ENCHANTED, (Object)false);
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        if (this.isWakeUp(stack)) {
            stack.set(ModDataComponents.ENCHANTED, (Object)true);
            return ISoulConsumer.ConsumeResult.success(1);
        }
        return ISoulConsumer.ConsumeResult.fail();
    }

    @Override
    protected boolean doEffects(ServerLevel level, ServerPlayer player, ItemStack stack, @Nullable LivingEntity target) {
        Holder holder;
        Location location = this.getLocation(stack);
        Optional<String> id = this.getLocationId(stack);
        if (id.isEmpty() || location.isOrigin()) {
            LangKey.MESSAGE_TELEPORT_FAILED.sendMessage((Player)player, new Object[0]);
            this.resetStack((Level)level, stack);
            return false;
        }
        if (!((Boolean)ConfigTombstone.general.teleportDim.get()).booleanValue() && !location.isSameDimension((Level)level)) {
            LangKey.MESSAGE_TELEPORT_SAME_DIMENSION.sendMessage((Player)player, new Object[0]);
            return false;
        }
        ServerLevel targetWorld = Objects.requireNonNull(player.getServer()).getLevel(location.dim);
        if (!WorldHelper.isValidPos((Level)targetWorld, location.getPos())) {
            LangKey.MESSAGE_TELEPORT_FAILED.sendMessage((Player)player, new Object[0]);
            this.resetStack((Level)level, stack);
            return false;
        }
        Location spawnLoc = new SpawnHelper(targetWorld, location.getPos()).findStructurePlace(ResourceLocation.parse((String)id.get()));
        if (spawnLoc.isOrigin()) {
            LangKey.MESSAGE_NO_SPAWN.sendMessage((Player)player, new Object[0]);
            this.resetStack((Level)level, stack);
            return false;
        }
        EntityHelper.setGlobalItemCooldown((Player)player, this, 10);
        stack.remove(ModDataComponents.ENCHANTED);
        ModDataComponents.setLocation(stack, spawnLoc);
        if (this.getType(stack) == Type.EXPLORATION && !(holder = level.getBiome(spawnLoc.getPos())).is(ResourceLocation.parse((String)id.get()))) {
            holder.unwrapKey().ifPresent(k -> stack.set(ModDataComponents.LOST_TABLET_ID, (Object)k.toString()));
        }
        CallbackHandler.addFastCallback(() -> {
            ServerPlayer newPlayer = Helper.teleport(player, spawnLoc, targetWorld);
            LangKey.MESSAGE_TELEPORT_SUCCESS.sendMessage((Player)newPlayer, new Object[0]);
            ModTriggers.use_lost_tablet.trigger(newPlayer);
        });
        return true;
    }

    private void resetStack(Level level, ItemStack stack) {
        this.setWakeUpCooldown(level, stack, TimeHelper.tickFromMinute(10));
        stack.remove(ModDataComponents.ENCHANTED);
        stack.remove(ModDataComponents.LOST_TABLET_TYPE);
        stack.remove(ModDataComponents.LOST_TABLET_ID);
        stack.remove(ModDataComponents.LOCATION);
    }

    public Location getLocation(ItemStack stack) {
        return stack.is((Item)this) ? ModDataComponents.getLocation(stack) : Location.ORIGIN;
    }

    @Override
    protected boolean canConsumeOnUse() {
        return false;
    }

    public Type getType(ItemStack stack) {
        return Type.byId((Short)stack.getOrDefault(ModDataComponents.LOST_TABLET_TYPE, (Object)0));
    }

    public static enum Type {
        UNKNOWN,
        EXPLORATION,
        VILLAGE,
        TREASURE;


        public boolean isUnknown() {
            return this == UNKNOWN;
        }

        public static Type get(int roll) {
            return roll < 40 ? EXPLORATION : (roll < 70 ? VILLAGE : TREASURE);
        }

        private static Type byId(short id) {
            return id >= Type.values().length ? UNKNOWN : Type.values()[Math.max(0, id)];
        }
    }
}

