/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import ovh.corail.tombstone.combine.CombineCraft;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.ProxyHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ICombineCraft;
import ovh.corail.tombstone.item.ItemGeneric;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.network.SMessageCombination;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModTriggers;

public final class ItemStrangeTablet
extends ItemGeneric
implements ICombineCraft {
    private TooltipComponent tooltip;

    public ItemStrangeTablet() {
        super("strange_tablet");
        this.withCombineInfo();
    }

    public boolean overrideOtherStackedOnMe(ItemStack strangeTablet, ItemStack added, Slot slot, ClickAction action, Player player, SlotAccess slotAccess) {
        CombineCraft combine;
        if (action == ClickAction.SECONDARY && EntityHelper.isValidPlayer(player) && slot.allowModification(player) && strangeTablet.is((Item)this) && (combine = this.getCombination(added)) != null) {
            if (combine.isEnabled()) {
                boolean isServerSide;
                boolean bl = isServerSide = !player.level().isClientSide();
                if (isServerSide || player.isCreative()) {
                    ItemStack result = combine.result().copy();
                    added.shrink(1);
                    strangeTablet.shrink(1);
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)result);
                    if (isServerSide) {
                        ModTriggers.combine_in_inventory.trigger((ServerPlayer)player);
                    } else {
                        PacketHandler.sendToServer(new SMessageCombination(SMessageCombination.CombineType.COMBINE_IN_INVENTORY));
                    }
                }
            } else if (player.level().isClientSide) {
                ProxyHelper.addToast(combine.added(), combine.result(), (Component)LangKey.MESSAGE_DISABLED.getText(StyleType.COLOR_RED, new Object[0]));
            }
            return true;
        }
        return false;
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        if (this.tooltip == null) {
            this.tooltip = this.createTooltip();
        }
        return Optional.of(this.tooltip);
    }

    @Override
    public void addCombinations(List<CombineCraft> combinations) {
        combinations.add(new CombineCraft((TagKey<Item>)Tags.Items.GUNPOWDERS, new ItemStack((ItemLike)ModItems.tablet_of_assistance), ModItems.tablet_of_assistance::isEnabled));
        combinations.add(new CombineCraft(new ItemStack((ItemLike)Items.GOLDEN_CARROT), new ItemStack((ItemLike)ModItems.tablet_of_cupidity), ModItems.tablet_of_cupidity::isEnabled));
        combinations.add(new CombineCraft(new ItemStack((ItemLike)Items.RED_MUSHROOM), new ItemStack((ItemLike)ModItems.tablet_of_home), ModItems.tablet_of_home::isEnabled));
        combinations.add(new CombineCraft(new ItemStack((ItemLike)Items.BONE_MEAL), new ItemStack((ItemLike)ModItems.tablet_of_recall), ModItems.tablet_of_recall::isEnabled));
        combinations.add(new CombineCraft((TagKey<Item>)Tags.Items.BONES, new ItemStack((ItemLike)ModItems.tablet_of_guard), ModItems.tablet_of_guard::isEnabled));
    }
}

