/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.loot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import ovh.corail.tombstone.api.item.IDisableable;
import ovh.corail.tombstone.loot.IDelayedNBTLoot;
import ovh.corail.tombstone.registry.ModLootFunctions;

public class DelayedNBTFunction
extends LootItemConditionalFunction {
    public static final ResourceLocation RL = ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"delayed_nbt_loot");
    public static final MapCodec<DelayedNBTFunction> CODEC = RecordCodecBuilder.mapCodec(b -> DelayedNBTFunction.commonFields((RecordCodecBuilder.Instance)b).apply((Applicative)b, DelayedNBTFunction::new));

    private DelayedNBTFunction(List<LootItemCondition> conditionsIn) {
        super(conditionsIn);
    }

    public LootItemFunctionType<DelayedNBTFunction> getType() {
        return ModLootFunctions.DELAYED_NBT_LOOT;
    }

    protected ItemStack run(ItemStack stack, LootContext context) {
        ItemStack itemStack;
        IDisableable disableable;
        Item item = stack.getItem();
        if (item instanceof IDisableable && !(disableable = (IDisableable)item).isEnabled()) {
            return ItemStack.EMPTY;
        }
        item = stack.getItem();
        if (item instanceof IDelayedNBTLoot) {
            IDelayedNBTLoot delayedNBTLoot = (IDelayedNBTLoot)item;
            itemStack = delayedNBTLoot.onDelayedLoot(stack, context);
        } else {
            itemStack = stack;
        }
        return itemStack;
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        protected Builder getThis() {
            return this;
        }

        public LootItemFunction build() {
            return new DelayedNBTFunction(this.getConditions());
        }
    }
}

