/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.mixin;

import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.registry.ModDataComponents;

@Mixin(value={Item.class}, priority=1031)
public abstract class ItemMixin {
    @Inject(method={"getName(Lnet/minecraft/world/item/ItemStack;)Lnet/minecraft/network/chat/Component;"}, at={@At(value="HEAD")}, cancellable=true)
    private void methodGetName(ItemStack stack, CallbackInfoReturnable<Component> callbackInfoReturnable) {
        if (stack.is(Items.TIPPED_ARROW) && ((Boolean)stack.getOrDefault(ModDataComponents.ENCHANTED_ARROW, (Object)false)).booleanValue()) {
            List effectInstances = ((PotionContents)stack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY)).customEffects();
            if (effectInstances.size() > 1) {
                callbackInfoReturnable.setReturnValue((Object)Component.translatable((String)"tombstone.item.cursed_arrow"));
            } else {
                MobEffectInstance effectInstance = (MobEffectInstance)effectInstances.getFirst();
                int amplifier = effectInstance.getAmplifier();
                Component fullname = ((MobEffect)effectInstance.getEffect().value()).getDisplayName();
                if (amplifier > 0) {
                    fullname = fullname.copy().append(" " + EffectHelper.getPotency(effectInstance.getAmplifier() + 1));
                }
                callbackInfoReturnable.setReturnValue((Object)Component.translatable((String)"tombstone.item.arrow_of", (Object[])new Object[]{fullname}));
            }
        }
    }
}

