/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.registry.ModEffects;

@Mixin(value={PlayerRenderer.class})
public abstract class PlayerRendererMixin
extends LivingEntityRenderer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private PlayerRendererMixin(EntityRendererProvider.Context context, PlayerModel<AbstractClientPlayer> model, float shadow) {
        super(context, model, shadow);
    }

    @Inject(method={"renderHand"}, at={@At(value="HEAD")}, cancellable=true)
    private void renderHand(PoseStack poseStack, MultiBufferSource bufferSource, int light, AbstractClientPlayer player, ModelPart part1, ModelPart part2, CallbackInfo callbackInfo) {
        if (player != null && (player.hasEffect(ModEffects.ghostly_shape) || EffectHelper.isUnstableIntangibilityActive((LivingEntity)player))) {
            PlayerModel playerModel = (PlayerModel)this.getModel();
            this.setModelProperties(player);
            playerModel.attackTime = 0.0f;
            playerModel.crouching = false;
            playerModel.swimAmount = 0.0f;
            playerModel.setupAnim((LivingEntity)player, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            int color = Helper.convertColorToInt(0.3f, 0.5f, 1.0f, 1.0f);
            part1.xRot = 0.0f;
            part1.render(poseStack, bufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)player.getSkin().texture())), light, OverlayTexture.NO_OVERLAY, color);
            part2.xRot = 0.0f;
            part2.render(poseStack, bufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)player.getSkin().texture())), light, OverlayTexture.NO_OVERLAY, color);
            callbackInfo.cancel();
        }
    }

    @Shadow
    public abstract void setModelProperties(AbstractClientPlayer var1);
}

