/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.ProxyHelper;

public record CMessageEffectStarted(int entityId, MobEffectInstance effectInstance) implements CustomPacketPayload
{
    static final StreamCodec<RegistryFriendlyByteBuf, CMessageEffectStarted> STREAM_CODEC = StreamCodec.ofMember(CMessageEffectStarted::encode, CMessageEffectStarted::decode);
    static final CustomPacketPayload.Type<CMessageEffectStarted> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"effect"));

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    static CMessageEffectStarted decode(RegistryFriendlyByteBuf buf) {
        int id = buf.readVarInt();
        @Nullable CompoundTag effectInstanceTag = buf.readNbt();
        MobEffectInstance effectInstance = NBTStackHelper.getEffect(effectInstanceTag, "effect").orElse(new MobEffectInstance(MobEffects.SATURATION));
        return new CMessageEffectStarted(id, effectInstance);
    }

    static void encode(CMessageEffectStarted msg, RegistryFriendlyByteBuf buf) {
        buf.writeVarInt(msg.entityId);
        CompoundTag tag = new CompoundTag();
        NBTStackHelper.setEffect(tag, "effect", msg.effectInstance);
        buf.writeNbt((Tag)tag);
    }

    static void handle(CMessageEffectStarted msg, IPayloadContext ctx) {
        ProxyHelper.getClientWorld().map(level -> level.getEntity(msg.entityId)).filter(LivingEntity.class::isInstance).map(LivingEntity.class::cast).ifPresent(entity -> {
            MobEffectInstance effectInstance = new MobEffectInstance(msg.effectInstance);
            entity.forceAddEffect(effectInstance, null);
        });
    }
}

