/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.network;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import ovh.corail.tombstone.helper.ProxyHelper;

public record CMessageSmokeColumn(Vec3 posVec) implements CustomPacketPayload
{
    static final StreamCodec<RegistryFriendlyByteBuf, CMessageSmokeColumn> STREAM_CODEC = StreamCodec.ofMember(CMessageSmokeColumn::encode, CMessageSmokeColumn::decode);
    static final CustomPacketPayload.Type<CMessageSmokeColumn> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"smoke_column"));

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    static CMessageSmokeColumn decode(RegistryFriendlyByteBuf buf) {
        return new CMessageSmokeColumn(new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble()));
    }

    static void encode(CMessageSmokeColumn msg, RegistryFriendlyByteBuf buf) {
        buf.writeDouble(msg.posVec().x);
        buf.writeDouble(msg.posVec().y);
        buf.writeDouble(msg.posVec().z);
    }

    static void handle(CMessageSmokeColumn msg, IPayloadContext ctx) {
        ProxyHelper.getClientWorld().ifPresent(level -> ProxyHelper.produceSmokeColumn(level, msg.posVec));
    }
}

