/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.block.tile;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.modularrouters.block.CamouflageableBlock;
import me.desht.modularrouters.block.tile.ICamouflageable;
import me.desht.modularrouters.core.ModBlockEntities;
import me.desht.modularrouters.util.Scheduler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.data.ModelData;

public class TemplateFrameBlockEntity
extends BlockEntity
implements ICamouflageable {
    private static final String NBT_CAMO_NAME = "CamouflageName";
    private static final String NBT_MIMIC = "Mimic";
    private BlockState camouflage = null;
    private boolean extendedMimic;

    public TemplateFrameBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.TEMPLATE_FRAME.get(), pos, state);
    }

    @Override
    public BlockState getCamouflage() {
        return this.camouflage;
    }

    public void setCamouflage(BlockState camouflage) {
        this.camouflage = camouflage;
        this.requestModelDataUpdate();
        this.setChanged();
    }

    @Nonnull
    public ModelData getModelData() {
        return ModelData.builder().with(CamouflageableBlock.CAMOUFLAGE_STATE, (Object)this.camouflage).build();
    }

    @Override
    public boolean extendedMimic() {
        return this.extendedMimic;
    }

    public void setExtendedMimic(boolean mimic) {
        this.extendedMimic = mimic;
        this.setChanged();
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        this.camouflage = this.getCamoStateFromNBT(compound, provider);
        this.extendedMimic = compound.getBoolean(NBT_MIMIC);
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.putBoolean(NBT_MIMIC, this.extendedMimic);
        if (this.camouflage != null) {
            compound.put(NBT_CAMO_NAME, (Tag)NbtUtils.writeBlockState((BlockState)this.camouflage));
        }
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider provider) {
        if (pkt.getTag() != null) {
            this.camouflage = this.getCamoStateFromNBT(pkt.getTag(), provider);
            this.extendedMimic = pkt.getTag().getBoolean(NBT_MIMIC);
            if (this.camouflage != null && this.extendedMimic && this.camouflage.getLightEmission((BlockGetter)this.getLevel(), this.getBlockPos()) > 0) {
                Objects.requireNonNull(this.getLevel()).getChunkSource().getLightEngine().checkBlock(this.worldPosition);
            }
        }
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider provider) {
        super.handleUpdateTag(tag, provider);
        this.camouflage = this.getCamoStateFromNBT(tag, provider);
        this.extendedMimic = tag.getBoolean(NBT_MIMIC);
        if (this.camouflage != null && this.extendedMimic && this.camouflage.getLightEmission((BlockGetter)this.getLevel(), this.getBlockPos()) > 0) {
            Scheduler.client().schedule(() -> Objects.requireNonNull(this.getLevel()).getChunkSource().getLightEngine().checkBlock(this.worldPosition), 1L);
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag compound = new CompoundTag();
        compound.putInt("x", this.worldPosition.getX());
        compound.putInt("y", this.worldPosition.getY());
        compound.putInt("z", this.worldPosition.getZ());
        compound.putBoolean(NBT_MIMIC, this.extendedMimic);
        return TemplateFrameBlockEntity.getNBTFromCamoState(compound, this.camouflage);
    }

    private BlockState getCamoStateFromNBT(CompoundTag tag, HolderLookup.Provider provider) {
        HolderLookup.RegistryLookup lookup = provider.lookup(Registries.BLOCK).orElse(BuiltInRegistries.BLOCK.asLookup());
        if (tag.contains(NBT_CAMO_NAME)) {
            return NbtUtils.readBlockState((HolderGetter)lookup, (CompoundTag)tag.getCompound(NBT_CAMO_NAME));
        }
        return null;
    }

    private static CompoundTag getNBTFromCamoState(CompoundTag compound, BlockState camouflage) {
        if (camouflage != null) {
            compound.put(NBT_CAMO_NAME, (Tag)NbtUtils.writeBlockState((BlockState)camouflage));
        }
        return compound;
    }

    public void setCamouflage(ItemStack itemStack, Direction facing, Direction routerFacing) {
        Item item = itemStack.getItem();
        if (item instanceof BlockItem) {
            BlockItem b = (BlockItem)item;
            this.camouflage = b.getBlock().defaultBlockState();
            if (this.camouflage.hasProperty((Property)BlockStateProperties.AXIS)) {
                this.camouflage = (BlockState)this.camouflage.setValue((Property)BlockStateProperties.AXIS, (Comparable)facing.getAxis());
            } else if (this.camouflage.hasProperty((Property)BlockStateProperties.FACING)) {
                this.camouflage = (BlockState)this.camouflage.setValue((Property)BlockStateProperties.FACING, (Comparable)facing);
            } else if (this.camouflage.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
                this.camouflage = (BlockState)this.camouflage.setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)(facing.getAxis() == Direction.Axis.Y ? routerFacing : facing));
            }
            this.setChanged();
        }
    }
}

