/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.filter;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import me.desht.modularrouters.client.gui.filter.AbstractFilterContainerScreen;
import me.desht.modularrouters.client.gui.filter.Buttons;
import me.desht.modularrouters.client.gui.widgets.button.BackButton;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.container.AbstractSmartFilterMenu;
import me.desht.modularrouters.item.smartfilter.TagFilter;
import me.desht.modularrouters.network.messages.FilterUpdateMessage;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import net.neoforged.neoforge.network.PacketDistributor;

public class TagFilterScreen
extends AbstractFilterContainerScreen {
    private static final ResourceLocation TEXTURE_LOCATION = MiscUtil.RL("textures/gui/tagfilter.png");
    private static final int GUI_WIDTH = 256;
    private static final int GUI_HEIGHT = 252;
    private final List<TagKey<Item>> addedTags = Lists.newArrayList();
    private final List<Buttons.DeleteButton> deleteButtons = Lists.newArrayList();
    private ItemStack prevInSlot = ItemStack.EMPTY;
    private final List<TagKey<Item>> candidateTags = new ArrayList<TagKey<Item>>();
    private TagKey<Item> selectedTag = null;
    private boolean tagSelectorShowing = false;
    private ExtendedButton selectButton;
    private final List<ExtendedButton> optionButtons = new ArrayList<ExtendedButton>();

    public TagFilterScreen(AbstractSmartFilterMenu container, Inventory inv, Component displayName) {
        super(container, inv, displayName);
        this.imageWidth = 256;
        this.imageHeight = 252;
        this.addedTags.addAll(TagFilter.getTagList(this.filterStack));
    }

    public void init() {
        super.init();
        if (((AbstractSmartFilterMenu)this.menu).getLocator().filterSlot() >= 0) {
            this.addRenderableWidget((GuiEventListener)new BackButton(this.leftPos - 12, this.topPos, p -> this.closeGUI()));
        }
        this.addRenderableWidget((GuiEventListener)new Buttons.AddButton(this.leftPos + 234, this.topPos + 19, p -> {
            if (this.selectedTag != null) {
                LinkedHashSet<TagKey<Item>> updatedTags = new LinkedHashSet<TagKey<Item>>(this.addedTags);
                updatedTags.add(this.selectedTag);
                this.sendTagsToServer(updatedTags);
            }
        }));
        this.deleteButtons.clear();
        for (int i = 0; i < 6; ++i) {
            Buttons.DeleteButton b = new Buttons.DeleteButton(this.leftPos + 8, this.topPos + 44 + i * 19, i, button -> this.sendTagsToServer(button.removeFromList(new ArrayList<TagKey<Item>>(this.addedTags))));
            this.addRenderableWidget((GuiEventListener)b);
            this.deleteButtons.add(b);
        }
        this.selectButton = new ExtendedButton(this.leftPos + 218, this.topPos + 20, 14, 14, (Component)Component.literal((String)"\u25bc"), p -> {
            this.tagSelectorShowing = !this.tagSelectorShowing;
            this.updateButtonVisibility();
        });
        this.addRenderableWidget((GuiEventListener)this.selectButton);
        this.selectButton.visible = false;
        this.updateButtonVisibility();
    }

    private void sendTagsToServer(Collection<TagKey<Item>> newTags) {
        ItemStack newStack = (ItemStack)Util.make((Object)this.filterStack.copy(), s -> TagFilter.setTagList(s, List.copyOf(newTags)));
        PacketDistributor.sendToServer((CustomPacketPayload)new FilterUpdateMessage(((AbstractSmartFilterMenu)this.menu).getLocator(), newStack), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void updateButtonVisibility() {
        for (int i = 0; i < this.deleteButtons.size(); ++i) {
            this.deleteButtons.get((int)i).visible = i < this.addedTags.size() && !this.tagSelectorShowing;
        }
        this.optionButtons.forEach(b -> {
            b.visible = this.tagSelectorShowing;
        });
        this.selectButton.setMessage((Component)Component.literal((String)(this.tagSelectorShowing ? "\u25b2" : "\u25bc")));
        this.selectButton.visible = this.candidateTags.size() > 1;
    }

    private void rebuildOptionButtons() {
        this.optionButtons.forEach(x$0 -> this.removeWidget((GuiEventListener)x$0));
        this.optionButtons.clear();
        if (this.candidateTags.size() > 1) {
            for (int i = 0; i < this.candidateTags.size(); ++i) {
                Objects.requireNonNull(this.font);
                SelectorButton sb = new SelectorButton(this, this.leftPos + 8, this.topPos + 44 + i * (9 + 5), this.candidateTags.get(i));
                this.optionButtons.add(sb);
                this.addRenderableWidget((GuiEventListener)sb);
            }
        }
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        MutableComponent txt = this.filterStack.getHoverName().copy().append(" ").append((Component)(((AbstractSmartFilterMenu)this.menu).getRouter() != null ? ClientUtil.xlate("modularrouters.guiText.label.installed", new Object[0]) : Component.empty()));
        graphics.drawString(this.font, (Component)txt, this.imageWidth / 2 - this.font.width((FormattedText)txt) / 2, 8, 0x404040, false);
        if (this.selectedTag != null) {
            int maxW = this.selectButton.visible ? 190 : 205;
            graphics.drawString(this.font, ClientUtil.ellipsize(this.font, this.selectedTag.location().toString(), maxW), 29, 23, 0x404040, false);
        } else if (this.candidateTags.size() > 1) {
            graphics.drawString(this.font, (Component)ClientUtil.xlate("modularrouters.guiText.label.selectTag", new Object[0]).withStyle(ChatFormatting.ITALIC), 29, 23, 0x808080, false);
        } else if (this.candidateTags.isEmpty()) {
            graphics.drawString(this.font, (Component)ClientUtil.xlate("modularrouters.guiText.label.noTags", new Object[0]).withStyle(ChatFormatting.ITALIC), 29, 23, 0x808080, false);
        }
        if (!this.tagSelectorShowing) {
            for (int i = 0; i < this.addedTags.size(); ++i) {
                String tag = this.addedTags.get(i).location().toString();
                graphics.drawString(this.font, ClientUtil.ellipsize(this.font, tag, 220), 28, 47 + i * 19, 0x404080, false);
            }
        }
    }

    public void containerTick() {
        super.containerTick();
        ItemStack inSlot = (ItemStack)((AbstractSmartFilterMenu)this.getMenu()).getItems().get(0);
        if (inSlot.isEmpty() && !this.prevInSlot.isEmpty()) {
            this.candidateTags.clear();
            this.selectedTag = null;
            this.tagSelectorShowing = false;
            this.rebuildOptionButtons();
            this.updateButtonVisibility();
        } else if (!(inSlot.isEmpty() || !this.prevInSlot.isEmpty() && MiscUtil.sameItemStackIgnoreDurability(inSlot, this.prevInSlot))) {
            List<TagKey> l = MiscUtil.itemTags(inSlot.getItem()).stream().sorted(Comparator.comparing(TagKey::location)).toList();
            this.candidateTags.clear();
            this.candidateTags.addAll(l);
            this.selectedTag = this.candidateTags.size() == 1 ? l.get(0) : null;
            this.rebuildOptionButtons();
            this.updateButtonVisibility();
        }
        this.prevInSlot = inSlot;
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        graphics.blit(TEXTURE_LOCATION, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    @Override
    public void resync(ItemStack filterStack) {
        this.addedTags.clear();
        this.addedTags.addAll(TagFilter.getTagList(filterStack));
        this.tagSelectorShowing = false;
        this.updateButtonVisibility();
    }

    private class SelectorButton
    extends ExtendedButton {
        public SelectorButton(TagFilterScreen tagFilterScreen, int xPos, int yPos, TagKey<Item> tag) {
            Objects.requireNonNull(tagFilterScreen.font);
            super(xPos, yPos, 239, 9 + 5, (Component)Component.literal((String)tag.location().toString()), p -> {
                me$desht$modularrouters$client$gui$filter$TagFilterScreen$this.selectedTag = tag;
                me$desht$modularrouters$client$gui$filter$TagFilterScreen$this.tagSelectorShowing = false;
                tagFilterScreen.updateButtonVisibility();
            });
        }
    }
}

