/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.widgets;

import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class EnergyWidget
extends AbstractWidget {
    private static final ResourceLocation TEXTURE_LOCATION = MiscUtil.RL("textures/gui/energy_widget.png");
    private static final int DEFAULT_SCALE = 64;
    private final IEnergyStorage storage;

    public EnergyWidget(int x, int y, IEnergyStorage storage) {
        super(x, y, 16, 64, (Component)Component.empty());
        this.storage = storage;
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int amount = this.getScaled();
        graphics.blit(TEXTURE_LOCATION, this.getX() + 1, this.getY(), 1.0f, 0.0f, this.width - 2, this.height, 32, 64);
        graphics.blit(TEXTURE_LOCATION, this.getX() + 1, this.getY() + 64 - amount, 17.0f, (float)(64 - amount), this.width - 2, amount, 32, 64);
        if (this.isHovered()) {
            MutableComponent text = Component.literal((String)(MiscUtil.commify(this.storage.getEnergyStored()) + " / " + MiscUtil.commify(this.storage.getMaxEnergyStored()) + " FE"));
            graphics.renderTooltip(Minecraft.getInstance().font, (Component)text, mouseX, mouseY);
        }
    }

    private int getScaled() {
        if (this.storage.getMaxEnergyStored() <= 0) {
            return this.height;
        }
        return (int)((long)this.storage.getEnergyStored() * (long)this.height / (long)this.storage.getMaxEnergyStored());
    }

    protected void updateWidgetNarration(NarrationElementOutput output) {
    }
}

