/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.gui.widgets.textfield;

import java.util.regex.Pattern;
import me.desht.modularrouters.client.gui.widgets.textfield.TextFieldWidgetMR;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.Range;

public class IntegerTextField
extends TextFieldWidgetMR {
    private Range<Integer> range;
    private int incr = 1;
    private int coarseIncr = 10;
    private int fineIncr = 1;
    private static final Pattern INT_MATCHER = Pattern.compile("^-?[0-9]+$");

    public IntegerTextField(Font fontrendererObj, int x, int y, int w, int h, Range<Integer> range) {
        super(fontrendererObj, x, y, w, h);
        this.setRange(range);
        this.setFilter(this::validate);
    }

    private boolean validate(String input) {
        if (input == null || input.isEmpty()) {
            return true;
        }
        if (!INT_MATCHER.matcher(input).matches()) {
            return false;
        }
        int n = Integer.parseInt(input);
        return this.range.contains((Object)n);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return switch (keyCode) {
            case 265 -> this.adjustField(this.getAdjustment());
            case 264 -> this.adjustField(-this.getAdjustment());
            case 266 -> this.adjustField((Integer)this.range.getMaximum());
            case 267 -> this.adjustField(-((Integer)this.range.getMaximum()).intValue());
            default -> super.keyPressed(keyCode, scanCode, modifiers);
        };
    }

    public void setRange(Range<Integer> range) {
        this.range = range;
        if (!range.contains((Object)this.getIntValue())) {
            this.setValue(Mth.clamp((int)this.getIntValue(), (int)((Integer)range.getMinimum()), (int)((Integer)range.getMaximum())));
        }
        this.setMaxLength(Math.max(Integer.toString((Integer)range.getMinimum()).length(), Integer.toString((Integer)range.getMaximum()).length()));
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        this.adjustField(pScrollY > 0.0 ? this.getAdjustment() : -this.getAdjustment());
        return true;
    }

    public void setValue(int val) {
        if (this.range.contains((Object)val)) {
            this.setValue(Integer.toString(val));
        }
    }

    public int getIntValue() {
        int val;
        try {
            val = Integer.parseInt(this.getValue());
        }
        catch (NumberFormatException e) {
            val = (Integer)this.range.getMinimum();
        }
        return val;
    }

    public void setIncr(int incr, int coarseAdjustMult) {
        this.setIncr(incr, coarseAdjustMult, 1);
    }

    public void setIncr(int incr, int coarseAdjustMult, int fineAdjustDiv) {
        this.incr = incr;
        this.coarseIncr = incr * coarseAdjustMult;
        this.fineIncr = incr / fineAdjustDiv;
    }

    private int getAdjustment() {
        if (Screen.hasShiftDown()) {
            return this.coarseIncr;
        }
        if (Screen.hasControlDown()) {
            return this.fineIncr;
        }
        return this.incr;
    }

    private boolean adjustField(int adj) {
        int newVal = Mth.clamp((int)(this.getIntValue() + adj), (int)((Integer)this.range.getMinimum()), (int)((Integer)this.range.getMaximum()));
        if (newVal != this.getIntValue()) {
            this.setValue("");
            this.insertText(Integer.toString(newVal));
        }
        return true;
    }
}

