/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.client.render.area;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.desht.modularrouters.client.render.ModRenderTypes;
import me.desht.modularrouters.client.render.area.IPositionProvider;
import me.desht.modularrouters.logic.ModuleTarget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;

public class ModuleTargetRenderer {
    private static final float BOX_SIZE = 0.5f;
    private static final float BOX_START = 0.25f;
    private static ItemStack lastStack = ItemStack.EMPTY;
    private static CompiledPosition compiledPos = null;

    @SubscribeEvent
    public static void clientTick(ClientTickEvent.Pre event) {
        if (Minecraft.getInstance().player != null) {
            ItemStack curItem = Minecraft.getInstance().player.getMainHandItem();
            Item item = curItem.getItem();
            if (item instanceof IPositionProvider) {
                IPositionProvider posProvider = (IPositionProvider)item;
                if (!ItemStack.matches((ItemStack)curItem, (ItemStack)lastStack)) {
                    lastStack = curItem.copy();
                    compiledPos = new CompiledPosition(curItem, posProvider);
                }
            } else {
                lastStack = ItemStack.EMPTY;
                compiledPos = null;
            }
        }
    }

    @SubscribeEvent
    public static void renderWorldLastEvent(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES && compiledPos != null) {
            MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
            PoseStack matrixStack = event.getPoseStack();
            matrixStack.pushPose();
            Vec3 projectedView = event.getCamera().getPosition();
            matrixStack.translate(-projectedView.x, -projectedView.y, -projectedView.z);
            ModuleTargetRenderer.render(buffer, matrixStack, compiledPos);
            matrixStack.popPose();
        }
    }

    private static void render(MultiBufferSource.BufferSource buffer, PoseStack matrixStack, CompiledPosition cp) {
        cp.positions.forEach((pos, faceAndColour) -> {
            matrixStack.pushPose();
            matrixStack.translate((float)pos.getX() + 0.25f, (float)pos.getY() + 0.25f, (float)pos.getZ() + 0.25f);
            Matrix4f posMat = matrixStack.last().pose();
            int color = faceAndColour.colour();
            int r = (color & 0xFF0000) >> 16;
            int g = (color & 0xFF00) >> 8;
            int b = color & 0xFF;
            VertexConsumer faceBuilder = buffer.getBuffer(ModRenderTypes.BLOCK_HILIGHT_FACE);
            int alpha = ModuleTargetRenderer.getFaceAlpha(faceAndColour, Direction.NORTH);
            faceBuilder.addVertex(posMat, 0.0f, 0.0f, 0.0f).setColor(r, g, b, alpha).setNormal(0.0f, 0.0f, -1.0f);
            faceBuilder.addVertex(posMat, 0.0f, 0.5f, 0.0f).setColor(r, g, b, alpha).setNormal(0.0f, 0.0f, -1.0f);
            faceBuilder.addVertex(posMat, 0.5f, 0.5f, 0.0f).setColor(r, g, b, alpha).setNormal(0.0f, 0.0f, -1.0f);
            faceBuilder.addVertex(posMat, 0.5f, 0.0f, 0.0f).setColor(r, g, b, alpha).setNormal(0.0f, 0.0f, -1.0f);
            alpha = ModuleTargetRenderer.getFaceAlpha(faceAndColour, Direction.SOUTH);
            faceBuilder.addVertex(posMat, 0.5f, 0.0f, 0.5f).setColor(r, g, b, alpha).setNormal(0.0f, 0.0f, 1.0f);
            faceBuilder.addVertex(posMat, 0.5f, 0.5f, 0.5f).setColor(r, g, b, alpha).setNormal(0.0f, 0.0f, 1.0f);
            faceBuilder.addVertex(posMat, 0.0f, 0.5f, 0.5f).setColor(r, g, b, alpha).setNormal(0.0f, 0.0f, 1.0f);
            faceBuilder.addVertex(posMat, 0.0f, 0.0f, 0.5f).setColor(r, g, b, alpha).setNormal(0.0f, 0.0f, 1.0f);
            alpha = ModuleTargetRenderer.getFaceAlpha(faceAndColour, Direction.WEST);
            faceBuilder.addVertex(posMat, 0.0f, 0.0f, 0.0f).setColor(r, g, b, alpha).setNormal(-1.0f, 0.0f, 0.0f);
            faceBuilder.addVertex(posMat, 0.0f, 0.0f, 0.5f).setColor(r, g, b, alpha).setNormal(-1.0f, 0.0f, 0.0f);
            faceBuilder.addVertex(posMat, 0.0f, 0.5f, 0.5f).setColor(r, g, b, alpha).setNormal(-1.0f, 0.0f, 0.0f);
            faceBuilder.addVertex(posMat, 0.0f, 0.5f, 0.0f).setColor(r, g, b, alpha).setNormal(-1.0f, 0.0f, 0.0f);
            alpha = ModuleTargetRenderer.getFaceAlpha(faceAndColour, Direction.EAST);
            faceBuilder.addVertex(posMat, 0.5f, 0.5f, 0.0f).setColor(r, g, b, alpha).setNormal(1.0f, 0.0f, 0.0f);
            faceBuilder.addVertex(posMat, 0.5f, 0.5f, 0.5f).setColor(r, g, b, alpha).setNormal(1.0f, 0.0f, 0.0f);
            faceBuilder.addVertex(posMat, 0.5f, 0.0f, 0.5f).setColor(r, g, b, alpha).setNormal(1.0f, 0.0f, 0.0f);
            faceBuilder.addVertex(posMat, 0.5f, 0.0f, 0.0f).setColor(r, g, b, alpha).setNormal(1.0f, 0.0f, 0.0f);
            alpha = ModuleTargetRenderer.getFaceAlpha(faceAndColour, Direction.DOWN);
            faceBuilder.addVertex(posMat, 0.0f, 0.0f, 0.0f).setColor(r, g, b, alpha).setNormal(0.0f, -1.0f, 0.0f);
            faceBuilder.addVertex(posMat, 0.5f, 0.0f, 0.0f).setColor(r, g, b, alpha).setNormal(0.0f, -1.0f, 0.0f);
            faceBuilder.addVertex(posMat, 0.5f, 0.0f, 0.5f).setColor(r, g, b, alpha).setNormal(0.0f, -1.0f, 0.0f);
            faceBuilder.addVertex(posMat, 0.0f, 0.0f, 0.5f).setColor(r, g, b, alpha).setNormal(0.0f, -1.0f, 0.0f);
            alpha = ModuleTargetRenderer.getFaceAlpha(faceAndColour, Direction.UP);
            faceBuilder.addVertex(posMat, 0.0f, 0.5f, 0.5f).setColor(r, g, b, alpha).setNormal(0.0f, 1.0f, 0.0f);
            faceBuilder.addVertex(posMat, 0.5f, 0.5f, 0.5f).setColor(r, g, b, alpha).setNormal(0.0f, 1.0f, 0.0f);
            faceBuilder.addVertex(posMat, 0.5f, 0.5f, 0.0f).setColor(r, g, b, alpha).setNormal(0.0f, 1.0f, 0.0f);
            faceBuilder.addVertex(posMat, 0.0f, 0.5f, 0.0f).setColor(r, g, b, alpha).setNormal(0.0f, 1.0f, 0.0f);
            RenderSystem.disableDepthTest();
            buffer.endBatch(ModRenderTypes.BLOCK_HILIGHT_FACE);
            VertexConsumer lineBuilder = buffer.getBuffer(ModRenderTypes.BLOCK_HILIGHT_LINE);
            LevelRenderer.renderLineBox((PoseStack)matrixStack, (VertexConsumer)lineBuilder, (double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)0.5, (double)0.5, (float)0.25f, (float)0.25f, (float)0.25f, (float)0.3125f);
            RenderSystem.disableDepthTest();
            buffer.endBatch(ModRenderTypes.BLOCK_HILIGHT_LINE);
            matrixStack.popPose();
        });
    }

    private static int getFaceAlpha(CompiledPosition.FaceAndColour fc, Direction face) {
        return fc.faces.get(face.get3DDataValue()) ? 160 : 40;
    }

    static class CompiledPosition {
        private final Map<BlockPos, FaceAndColour> positions = new HashMap<BlockPos, FaceAndColour>();

        CompiledPosition(ItemStack stack, IPositionProvider provider) {
            List<ModuleTarget> targets = provider.getStoredPositions(stack);
            for (int i = 0; i < targets.size(); ++i) {
                ModuleTarget target = targets.get(i);
                if (!target.isSameWorld((Level)Minecraft.getInstance().level)) continue;
                BlockPos pos = target.gPos.pos();
                if (this.positions.containsKey(pos)) {
                    this.positions.get((Object)pos).faces.set(target.face.get3DDataValue());
                    continue;
                }
                FaceAndColour fc = new FaceAndColour(new BitSet(6), provider.getRenderColor(i));
                fc.faces.set(target.face.get3DDataValue());
                this.positions.put(pos, fc);
            }
        }

        record FaceAndColour(BitSet faces, int colour) {
        }
    }
}

