/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.module;

import java.util.List;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.client.util.TintColor;
import me.desht.modularrouters.config.ConfigHolder;
import me.desht.modularrouters.container.Extruder2ModuleMenu;
import me.desht.modularrouters.container.ModuleMenu;
import me.desht.modularrouters.core.ModDataComponents;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.item.module.IRangedModule;
import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.logic.compiled.CompiledExtruderModule2;
import me.desht.modularrouters.util.MFLocator;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;

public class ExtruderModule2
extends ModuleItem
implements IRangedModule {
    private static final TintColor TINT_COLOR = new TintColor(227, 174, 27);

    public ExtruderModule2() {
        super(ModItems.moduleProps().component(ModDataComponents.EXTRUDER2_TEMPLATE, (Object)ItemContainerContents.EMPTY), CompiledExtruderModule2::new);
    }

    @Override
    public void addSettingsInformation(ItemStack stack, List<Component> list) {
        super.addSettingsInformation(stack, list);
        list.add((Component)ClientUtil.xlate("modularrouters.itemText.extruder2.template", new Object[0]).withStyle(ChatFormatting.YELLOW));
        int size = list.size();
        Extruder2ModuleMenu.TemplateHandler handler = new Extruder2ModuleMenu.TemplateHandler(stack, null);
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack blockStack = handler.getStackInSlot(i);
            if (blockStack.isEmpty()) continue;
            list.add((Component)Component.literal((String)(" \u2022 " + String.valueOf(ChatFormatting.AQUA) + blockStack.getCount() + " x ")).append(blockStack.getHoverName()));
        }
        if (list.size() == size) {
            Component tc = list.get(size - 1);
            list.set(list.size() - 1, (Component)MiscUtil.asMutableComponent(tc).append(" ").append((Component)ClientUtil.xlate("modularrouters.itemText.misc.noItems", new Object[0]).withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.ITALIC})));
        }
    }

    @Override
    ModuleMenu createContainer(int windowId, Inventory invPlayer, MFLocator loc) {
        return new Extruder2ModuleMenu(windowId, invPlayer, loc);
    }

    @Override
    public int getBaseRange() {
        return (Integer)ConfigHolder.common.module.extruder2BaseRange.get();
    }

    @Override
    public int getHardMaxRange() {
        return (Integer)ConfigHolder.common.module.extruder2MaxRange.get();
    }

    @Override
    public TintColor getItemTint() {
        return TINT_COLOR;
    }

    @Override
    public int getEnergyCost(ItemStack stack) {
        return (Integer)ConfigHolder.common.energyCosts.extruderModule2EnergyCost.get();
    }
}

