/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import javax.annotation.Nonnull;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.config.ConfigHolder;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.item.upgrade.UpgradeItem;
import me.desht.modularrouters.logic.ModuleTarget;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.util.BeamData;
import me.desht.modularrouters.util.BlockUtil;
import me.desht.modularrouters.util.InventoryUtils;
import me.desht.modularrouters.util.MiscUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class CompiledSenderModule1
extends CompiledModule {
    public CompiledSenderModule1(ModularRouterBlockEntity router, ItemStack stack) {
        super(router, stack);
    }

    @Override
    public boolean execute(@Nonnull ModularRouterBlockEntity router) {
        PositionedItemHandler positionedItemHandler;
        IItemHandler buffer = router.getBuffer();
        ItemStack bufferStack = buffer.getStackInSlot(0);
        if (this.getFilter().test(bufferStack) && (positionedItemHandler = this.findTargetInventory(router)).isValid()) {
            int sent;
            int nToSend = this.getItemsPerTick(router);
            if (this.getRegulationAmount() > 0) {
                int existing = InventoryUtils.countItems(bufferStack, positionedItemHandler.handler, this.getRegulationAmount(), !this.getFilter().getFlags().matchDamage());
                if ((nToSend = Math.min(nToSend, this.getRegulationAmount() - existing)) <= 0) {
                    return false;
                }
            }
            if ((sent = InventoryUtils.transferItems(buffer, positionedItemHandler.handler, 0, nToSend)) > 0) {
                if (((Boolean)ConfigHolder.common.module.senderParticles.get()).booleanValue()) {
                    this.playParticles(router, positionedItemHandler.pos, bufferStack.copyWithCount(sent));
                }
                return true;
            }
            return false;
        }
        return false;
    }

    void playParticles(ModularRouterBlockEntity router, BlockPos targetPos, ItemStack stack) {
        if (router.getUpgradeCount((UpgradeItem)ModItems.MUFFLER_UPGRADE.get()) < 2) {
            router.addItemBeam(new BeamData.Builder(router, targetPos, this.getBeamColor()).withItemStack(stack).build());
        }
    }

    protected int getBeamColor() {
        return 0xFFC000;
    }

    protected PositionedItemHandler findTargetInventory(ModularRouterBlockEntity router) {
        ModuleTarget target = this.getEffectiveTarget(router);
        if (target != null) {
            return target.getItemHandler().map(h -> new PositionedItemHandler(target.gPos.pos(), (IItemHandler)h)).orElse(PositionedItemHandler.INVALID);
        }
        return PositionedItemHandler.INVALID;
    }

    @Override
    public ModuleTarget getEffectiveTarget(ModularRouterBlockEntity router) {
        if (this.getAbsoluteFacing() != null) {
            BlockPos.MutableBlockPos pos = this.getTarget().gPos.pos().mutable();
            Direction face = this.getTarget().face;
            Level level = router.nonNullLevel();
            for (int i = 1; i <= this.getRange(); ++i) {
                if (level.getCapability(Capabilities.ItemHandler.BLOCK, (BlockPos)pos, (Object)this.getTarget().face) != null) {
                    GlobalPos gPos = MiscUtil.makeGlobalPos(level, pos.immutable());
                    return new ModuleTarget(gPos, face, BlockUtil.getBlockName(level, (BlockPos)pos));
                }
                if (!this.isPassable(level, (BlockPos)pos, face)) {
                    return null;
                }
                pos.move(this.getAbsoluteFacing());
            }
        }
        return null;
    }

    private boolean isPassable(Level w, BlockPos pos, Direction face) {
        BlockState state = w.getBlockState(pos);
        return !MiscUtil.blockHasSolidSide(state, (BlockGetter)w, pos, face.getOpposite()) || !state.isSolidRender((BlockGetter)w, pos);
    }

    public record PositionedItemHandler(BlockPos pos, IItemHandler handler) {
        static final PositionedItemHandler INVALID = new PositionedItemHandler(null, null);

        boolean isValid() {
            return this.pos != null && this.handler != null;
        }
    }
}

