/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.common.impl.registry.adapter;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.darkhax.bookshelf.common.api.registry.RegistrationContext;
import net.darkhax.bookshelf.common.api.registry.adapters.GameRegistryAdapter;
import net.darkhax.bookshelf.common.api.service.Services;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;

public class CreativeModeTabAdapter
extends GameRegistryAdapter<CreativeModeTab> {
    public CreativeModeTabAdapter(RegistrationContext context, ResourceKey<Registry<CreativeModeTab>> regKey, BiConsumer<ResourceKey<CreativeModeTab>, Supplier<CreativeModeTab>> registryFunc) {
        super(context, regKey, registryFunc);
    }

    public void add(String key, Supplier<ItemStack> icon, CreativeModeTab.DisplayItemsGenerator display) {
        this.add(key, (CreativeModeTab.Builder builder) -> {
            builder.title((Component)Component.translatable((String)("itemGroup." + this.context.namespace() + "." + key)));
            builder.icon(icon);
            builder.displayItems(display);
        });
    }

    public void add(String key, Consumer<CreativeModeTab.Builder> builderFunc) {
        CreativeModeTab.Builder builder = Services.GAMEPLAY.tabBuilder();
        builderFunc.accept(builder);
        this.add(key, builder.build());
    }
}

