/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.background.backgrounds.image;

import de.keksuccino.fancymenu.customization.background.backgrounds.image.ImageMenuBackground;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.cycle.CommonCycles;
import de.keksuccino.fancymenu.util.file.type.types.ImageFileType;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CellScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.resource.ResourceChooserScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.texteditor.TextEditorScreen;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.CycleButton;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import de.keksuccino.fancymenu.util.resource.ResourceSupplier;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;

public class ImageMenuBackgroundConfigScreen
extends CellScreen {
    @NotNull
    protected Consumer<ImageMenuBackground> callback;
    @NotNull
    ImageMenuBackground background;

    protected ImageMenuBackgroundConfigScreen(@NotNull ImageMenuBackground background, @NotNull Consumer<ImageMenuBackground> callback) {
        super((Component)Component.translatable((String)"fancymenu.background.image.configure"));
        this.background = background;
        this.callback = callback;
    }

    @Override
    protected void initCells() {
        this.addStartEndSpacerCell();
        this.addWidgetCell((AbstractWidget)new ExtendedButton(0, 0, 20, 20, (Component)Component.translatable((String)"fancymenu.background.image.configure.choose_image.local"), button -> {
            ResourceChooserScreen<ITexture, ImageFileType> s = ResourceChooserScreen.image(null, source -> {
                if (source != null) {
                    this.background.textureSupplier = ResourceSupplier.image(source);
                }
                Minecraft.getInstance().setScreen((Screen)this);
            });
            s.setSource(this.background.textureSupplier != null ? this.background.textureSupplier.getSourceWithPrefix() : null, false);
            Minecraft.getInstance().setScreen(s);
        }), true);
        this.addWidgetCell((AbstractWidget)new ExtendedButton(0, 0, 20, 20, (Component)Component.translatable((String)"fancymenu.background.image.type.web.fallback"), var1 -> {
            ResourceChooserScreen<ITexture, ImageFileType> s = ResourceChooserScreen.image(null, source -> {
                if (source != null) {
                    this.background.fallbackTextureSupplier = ResourceSupplier.image(source);
                }
                Minecraft.getInstance().setScreen((Screen)this);
            });
            s.setSource(this.background.fallbackTextureSupplier != null ? this.background.fallbackTextureSupplier.getSourceWithPrefix() : null, false);
            Minecraft.getInstance().setScreen(s);
        }).setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.background.image.type.web.fallback.desc", new String[0]))), true);
        this.addWidgetCell((AbstractWidget)new ExtendedButton(0, 0, 20, 20, (Component)Component.translatable((String)"fancymenu.background.image.type.web.fallback.reset").setStyle(Style.EMPTY.withColor(UIBase.getUIColorTheme().error_text_color.getColorInt())), var1 -> {
            this.background.fallbackTextureSupplier = null;
        }), true);
        this.addCellGroupEndSpacerCell();
        this.addCycleButtonCell(CommonCycles.cycleEnabledDisabled("fancymenu.background.image.restart_animated_on_menu_load", this.background.restartAnimatedOnMenuLoad), true, (value, button) -> {
            this.background.restartAnimatedOnMenuLoad = value.getAsBoolean();
        });
        CellScreen.WidgetCell repeatButton = this.addCycleButtonCell(CommonCycles.cycleEnabledDisabled("fancymenu.background.image.configure.repeat", this.background.repeat), true, (value, button) -> {
            this.background.repeat = value.getAsBoolean();
        });
        AbstractWidget abstractWidget = repeatButton.widget;
        if (abstractWidget instanceof CycleButton) {
            CycleButton b = (CycleButton)abstractWidget;
            b.setIsActiveSupplier(consumes -> !this.background.slideLeftRight);
        }
        CellScreen.WidgetCell slideButton = this.addCycleButtonCell(CommonCycles.cycleEnabledDisabled("fancymenu.background.image.configure.slide", this.background.slideLeftRight), true, (value, button) -> {
            this.background.slideLeftRight = value.getAsBoolean();
        });
        AbstractWidget abstractWidget2 = slideButton.widget;
        if (abstractWidget2 instanceof CycleButton) {
            CycleButton b = (CycleButton)abstractWidget2;
            b.setIsActiveSupplier(consumes -> !this.background.repeat && !this.background.parallaxEnabled);
        }
        CellScreen.WidgetCell parallaxButton = this.addCycleButtonCell(CommonCycles.cycleEnabledDisabled("fancymenu.background.image.configure.parallax", this.background.parallaxEnabled), true, (value, button) -> {
            this.background.parallaxEnabled = value.getAsBoolean();
        });
        AbstractWidget abstractWidget3 = parallaxButton.widget;
        if (abstractWidget3 instanceof CycleButton) {
            CycleButton b = (CycleButton)abstractWidget3;
            b.setIsActiveSupplier(consumes -> !this.background.slideLeftRight);
        }
        this.addWidgetCell((AbstractWidget)new ExtendedButton(0, 0, 0, 20, (Component)Component.translatable((String)"fancymenu.background.image.configure.parallax_intensity"), var1 -> {
            Screen currentScreen = Minecraft.getInstance().screen;
            TextEditorScreen s = TextEditorScreen.build((Component)Component.translatable((String)"fancymenu.background.image.configure.parallax_intensity"), null, callback -> {
                if (callback != null) {
                    this.background.parallaxIntensityString = callback;
                }
                Minecraft.getInstance().setScreen(currentScreen);
            });
            s.setText(this.background.parallaxIntensityString);
            Minecraft.getInstance().setScreen((Screen)s);
        }).setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.background.image.configure.parallax_intensity.desc", new String[0]))), true);
        CellScreen.WidgetCell invertParallaxCell = this.addCycleButtonCell(CommonCycles.cycleEnabledDisabled("fancymenu.background.image.configure.invert_parallax", this.background.invertParallax), true, (value, button) -> {
            this.background.invertParallax = value.getAsBoolean();
        });
        AbstractWidget abstractWidget4 = invertParallaxCell.widget;
        if (abstractWidget4 instanceof ExtendedButton) {
            ExtendedButton b = (ExtendedButton)abstractWidget4;
            b.setTooltip(Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.background.image.configure.invert_parallax.desc", new String[0])));
        }
        this.addStartEndSpacerCell();
    }

    @Override
    protected void init() {
        super.init();
        if (this.doneButton != null) {
            this.doneButton.setTooltipSupplier(consumes -> {
                if (this.background.textureSupplier == null) {
                    return Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.background.image.configure.no_image_chosen", new String[0]));
                }
                return null;
            });
        }
    }

    @Override
    public boolean allowDone() {
        return this.background.textureSupplier != null;
    }

    @Override
    protected void onCancel() {
        this.callback.accept(null);
    }

    @Override
    protected void onDone() {
        this.callback.accept(this.background);
    }
}

