/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.placeholder.placeholders.scoreboard;

import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.SerializationUtils;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.Scoreboard;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScoreboardObjectiveDisplayNamePlaceholder
extends Placeholder {
    public ScoreboardObjectiveDisplayNamePlaceholder() {
        super("scoreboard_objective_display_name");
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        Scoreboard scoreboard;
        Objective objective;
        ClientLevel level = Minecraft.getInstance().level;
        String objectiveName = dps.values.get("objective");
        boolean asJson = SerializationUtils.deserializeBoolean(false, dps.values.get("as_json"));
        if (level != null && objectiveName != null && (objective = (scoreboard = level.getScoreboard()).getObjective(objectiveName)) != null) {
            if (asJson) {
                String name = Component.Serializer.toJson((Component)objective.getDisplayName(), (HolderLookup.Provider)level.registryAccess());
                if (name.startsWith("\"") && name.endsWith("\"")) {
                    name = name.substring(1, name.length() - 1);
                }
                return name;
            }
            return objective.getDisplayName().getString();
        }
        return "";
    }

    @Override
    @Nullable
    public List<String> getValueNames() {
        return List.of("objective", "as_json");
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return I18n.get((String)"fancymenu.placeholders.scoreboard.objective_display_name", (Object[])new Object[0]);
    }

    @Override
    @Nullable
    public List<String> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.placeholders.scoreboard.objective_display_name.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return I18n.get((String)"fancymenu.placeholders.categories.scoreboard", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public DeserializedPlaceholderString getDefaultPlaceholderString() {
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        values.put("objective", "score");
        values.put("as_json", "false");
        return new DeserializedPlaceholderString(this.getIdentifier(), values, "");
    }
}

