/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.cable;

import com.google.common.collect.Iterables;
import com.google.common.primitives.Ints;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;
import owmii.powah.block.Tier;
import owmii.powah.block.Tiles;
import owmii.powah.block.cable.CableBlock;
import owmii.powah.block.cable.CableNet;
import owmii.powah.config.v2.types.CableConfig;
import owmii.powah.lib.block.AbstractEnergyStorage;
import owmii.powah.lib.block.IInventoryHolder;

public class CableTile
extends AbstractEnergyStorage<CableConfig, CableBlock>
implements IInventoryHolder {
    private static final String NBT_ENERGY_SIDES = "cs";
    public final EnumSet<Direction> energySides = EnumSet.noneOf(Direction.class);
    @Nullable
    CableNet net = null;
    protected MutableBoolean netInsertionGuard = new MutableBoolean(false);
    protected int startIndex = 0;
    private final BlockCapabilityCache<IEnergyStorage, @Nullable Direction>[] capabilityCaches = new BlockCapabilityCache[6];

    public CableTile(BlockPos pos, BlockState state, Tier variant) {
        super(Tiles.CABLE.get(), pos, state, variant);
    }

    public void clearRemoved() {
        super.clearRemoved();
        CableNet.addCable(this);
    }

    public void setRemoved() {
        super.setRemoved();
        CableNet.removeCable(this);
    }

    public boolean isActive() {
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return serverLevel.getChunkSource().isPositionTicking(ChunkPos.asLong((BlockPos)this.getBlockPos()));
        }
        return false;
    }

    protected Iterable<CableTile> getCables() {
        if (this.net == null) {
            CableNet.calculateNetwork(this);
        }
        this.startIndex %= this.net.cableList.size();
        return Iterables.concat(this.net.cableList.subList(this.startIndex, this.net.cableList.size()), this.net.cableList.subList(0, this.startIndex));
    }

    @Override
    public void readSync(CompoundTag compound, HolderLookup.Provider registries) {
        super.readSync(compound, registries);
        this.readEnergySides(compound);
    }

    @Override
    public CompoundTag writeSync(CompoundTag compound, HolderLookup.Provider registries) {
        this.writeEnergySides(compound);
        return super.writeSync(compound, registries);
    }

    private void readEnergySides(CompoundTag compound) {
        this.energySides.clear();
        byte sideBits = compound.getByte(NBT_ENERGY_SIDES);
        for (Direction side : Direction.values()) {
            if ((sideBits & CableTile.getSideMask(side)) == 0) continue;
            this.energySides.add(side);
        }
    }

    private void writeEnergySides(CompoundTag compound) {
        byte sideBits = 0;
        for (Direction side : this.energySides) {
            sideBits = (byte)(sideBits | CableTile.getSideMask(side));
        }
        compound.putByte(NBT_ENERGY_SIDES, sideBits);
    }

    private static byte getSideMask(Direction side) {
        return (byte)(1 << side.ordinal());
    }

    @Override
    protected long getEnergyCapacity() {
        return 0L;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 0;
    }

    @Override
    public boolean canInsert(int slot, ItemStack stack) {
        return false;
    }

    @Override
    public boolean canExtract(int slot, ItemStack stack) {
        return false;
    }

    @Override
    public boolean keepStorable() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long receiveEnergy(long maxReceive, boolean simulate, @Nullable Direction direction) {
        ServerLevel serverLevel;
        block10: {
            block9: {
                Level level = this.level;
                if (!(level instanceof ServerLevel)) break block9;
                serverLevel = (ServerLevel)level;
                if (direction != null && this.checkRedstone() && this.canReceiveEnergy(direction)) break block10;
            }
            return 0L;
        }
        long received = 0L;
        Iterable<CableTile> cables = this.getCables();
        MutableBoolean insertionGuard = this.netInsertionGuard;
        if (insertionGuard.isTrue()) {
            return 0L;
        }
        insertionGuard.setTrue();
        try {
            if (!simulate) {
                ++this.startIndex;
            }
            for (CableTile cable : cables) {
                long amount = maxReceive - received;
                if (amount <= 0L) break;
                if (cable.energySides.isEmpty() || !cable.isActive()) continue;
                received += cable.pushEnergy(serverLevel, amount, simulate, direction, this);
            }
            long l = received;
            return l;
        }
        finally {
            insertionGuard.setFalse();
        }
    }

    private long pushEnergy(ServerLevel level, long maxReceive, boolean simulate, @Nullable Direction direction, CableTile cable) {
        long received = 0L;
        for (int i = 0; i < 6; ++i) {
            Direction side = Direction.from3DDataValue((int)((i + level.getServer().getTickCount()) % 6));
            if (!this.energySides.contains(side)) continue;
            long amount = Math.min(maxReceive - received, this.energy.getMaxExtract());
            if (amount <= 0L) break;
            if (cable.equals(this) && side.equals((Object)direction) || !this.canExtractEnergy(side)) continue;
            BlockPos pos = this.worldPosition.relative(side);
            if (direction != null && cable.getBlockPos().relative(direction).equals((Object)pos)) continue;
            received += this.receive(level, pos, side.getOpposite(), amount, simulate);
        }
        return received;
    }

    private long receive(ServerLevel level, BlockPos pos, Direction side, long amount, boolean simulate) {
        IEnergyStorage energy;
        if (this.capabilityCaches[side.ordinal()] == null) {
            this.capabilityCaches[side.ordinal()] = BlockCapabilityCache.create((BlockCapability)Capabilities.EnergyStorage.BLOCK, (ServerLevel)level, (BlockPos)pos, (Object)side);
        }
        return (energy = (IEnergyStorage)this.capabilityCaches[side.ordinal()].getCapability()) != null ? (long)energy.receiveEnergy(Ints.saturatedCast((long)amount), simulate) : 0L;
    }

    public boolean canConnectTo(CableTile adjCable) {
        return this.variant == adjCable.variant;
    }
}

