/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.energizing;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import owmii.powah.block.Tiles;
import owmii.powah.block.energizing.EnergizingOrbBlock;
import owmii.powah.block.energizing.EnergizingRecipe;
import owmii.powah.lib.block.AbstractTickableTile;
import owmii.powah.lib.block.IInventoryHolder;
import owmii.powah.lib.logistics.energy.Energy;
import owmii.powah.lib.logistics.inventory.Inventory;
import owmii.powah.lib.registry.IVariant;
import owmii.powah.recipe.Recipes;

public class EnergizingOrbTile
extends AbstractTickableTile<IVariant.Single, EnergizingOrbBlock>
implements IInventoryHolder {
    private final Energy buffer = Energy.create(0L);
    private boolean containRecipe;
    @Nullable
    private RecipeHolder<EnergizingRecipe> recipe;

    public EnergizingOrbTile(BlockPos pos, BlockState state) {
        super(Tiles.ENERGIZING_ORB.get(), pos, state);
        this.inv.set(7);
    }

    @Override
    public void readSync(CompoundTag nbt, HolderLookup.Provider registries) {
        super.readSync(nbt, registries);
        this.buffer.read(nbt, "buffer", true, false);
        this.buffer.setTransfer(this.buffer.getCapacity());
        this.containRecipe = nbt.getBoolean("contain_recipe");
    }

    @Override
    public CompoundTag writeSync(CompoundTag nbt, HolderLookup.Provider registries) {
        this.buffer.write(nbt, "buffer", true, false);
        nbt.putBoolean("contain_recipe", this.containRecipe);
        return super.writeSync(nbt, registries);
    }

    public Direction getOrbUp() {
        BlockState state;
        if (this.level != null && (state = this.getBlockState()).hasProperty((Property)BlockStateProperties.FACING)) {
            return ((Direction)state.getValue((Property)BlockStateProperties.FACING)).getOpposite();
        }
        return Direction.UP;
    }

    public Vec3 getOrbCenter() {
        Direction up = this.getOrbUp();
        double scale = 0.1;
        return Vec3.atCenterOf((Vec3i)this.worldPosition).add((double)up.getStepX() * scale, (double)up.getStepY() * scale, (double)up.getStepZ() * scale);
    }

    @Nullable
    public RecipeHolder<EnergizingRecipe> currRecipe() {
        return this.recipe;
    }

    @Override
    protected void onFirstTick(Level world) {
        super.onFirstTick(world);
        this.checkRecipe();
    }

    @Override
    public void onSlotChanged(int index) {
        if (!this.isRemote()) {
            this.buffer.setCapacity(0L);
            this.buffer.setStored(0L);
            this.buffer.setTransfer(0L);
            this.checkRecipe();
        }
    }

    private void checkRecipe() {
        if (this.level != null && !this.isRemote()) {
            Optional recipe = this.level.getRecipeManager().getRecipeFor(Recipes.ENERGIZING.get(), (RecipeInput)new OrbInput(this.getInventory()), this.level);
            if (recipe.isPresent()) {
                this.recipe = (RecipeHolder)recipe.get();
                this.buffer.setCapacity(((EnergizingRecipe)this.recipe.value()).getScaledEnergy());
                this.buffer.setTransfer(((EnergizingRecipe)this.recipe.value()).getScaledEnergy());
            } else {
                this.buffer.setCapacity(0L);
                this.buffer.setStored(0L);
                this.buffer.setTransfer(0L);
            }
            this.setContainRecipe(recipe.isPresent());
            this.sync(1);
        }
    }

    public long fillEnergy(long amount) {
        long filled = Math.min(this.buffer.getEmpty(), amount);
        if (this.level != null && this.recipe != null) {
            this.buffer.produce(filled);
            if (this.buffer.isFull()) {
                ItemStack stack = ((EnergizingRecipe)this.recipe.value()).getResultItem((HolderLookup.Provider)this.level.registryAccess());
                this.inv.clear();
                this.inv.setStackInSlot(0, stack.copy());
                this.buffer.setCapacity(0L);
                this.buffer.setStored(0L);
                this.buffer.setTransfer(0L);
                this.setChanged();
            }
            this.sync(5);
        }
        return filled;
    }

    public boolean containRecipe() {
        return this.containRecipe;
    }

    public void setContainRecipe(boolean containRecipe) {
        this.containRecipe = containRecipe;
    }

    public Energy getBuffer() {
        return this.buffer;
    }

    @Override
    public int getSlotLimit(int index) {
        return index == 0 ? 64 : 1;
    }

    @Override
    public boolean canExtract(int slot, ItemStack stack) {
        return slot == 0;
    }

    @Override
    public boolean canInsert(int index, ItemStack stack) {
        return index != 0 && this.inv.getStackInSlot(0).isEmpty() && this.inv.getStackInSlot(index).isEmpty();
    }

    record OrbInput(Inventory inventory) implements RecipeInput
    {
        public ItemStack getItem(int index) {
            return this.inventory.getStackInSlot(index).copy();
        }

        public int size() {
            return this.inventory.getSlots();
        }
    }
}

