/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.reactor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import owmii.powah.block.reactor.ReactorBlock;
import owmii.powah.block.reactor.ReactorPartTile;
import owmii.powah.block.reactor.ReactorTile;
import owmii.powah.util.NBT;

public class Builder {
    private final ReactorTile reactor;
    private List<BlockPos> queue = new ArrayList<BlockPos>();
    public boolean built;
    private int delay = 5;

    public Builder(ReactorTile reactor) {
        this.reactor = reactor;
    }

    public void read(CompoundTag nbt) {
        this.built = nbt.getBoolean("built");
        if (!this.built) {
            this.queue = NBT.readPosList(nbt, "queue_pos", new ArrayList());
        }
    }

    public void write(CompoundTag nbt) {
        nbt.putBoolean("built", this.built);
        if (!this.built) {
            NBT.writePosList(nbt, this.queue, "queue_pos");
        }
    }

    public boolean isDone(Level world) {
        if (this.built) {
            return true;
        }
        if (!this.queue.isEmpty()) {
            if (this.delay-- <= 0) {
                Iterator<BlockPos> itr = this.queue.iterator();
                while (itr.hasNext()) {
                    BlockPos pos = itr.next();
                    BlockState state = ((ReactorBlock)this.reactor.getBlock()).defaultBlockState();
                    if (!world.getBlockState(pos).canBeReplaced()) {
                        this.demolish(world);
                        return false;
                    }
                    world.setBlock(pos, (BlockState)state.setValue((Property)ReactorBlock.CORE, (Comparable)Boolean.valueOf(false)), 3);
                    BlockEntity tileEntity = world.getBlockEntity(pos);
                    if (!(tileEntity instanceof ReactorPartTile)) continue;
                    ReactorPartTile part = (ReactorPartTile)tileEntity;
                    part.setCorePos(this.reactor.getBlockPos());
                    world.levelEvent(2001, pos, Block.getId((BlockState)this.reactor.getBlockState()));
                    itr.remove();
                    this.delay = 5;
                    return false;
                }
            }
        } else {
            for (Direction side : Direction.values()) {
                if (side.equals((Object)Direction.DOWN)) continue;
                BlockPos pos = this.reactor.getBlockPos().relative(side).above(side.equals((Object)Direction.UP) ? 2 : 0);
                BlockEntity tileEntity = world.getBlockEntity(pos);
                if (!(tileEntity instanceof ReactorPartTile)) continue;
                ReactorPartTile part = (ReactorPartTile)tileEntity;
                part.setExtractor(true);
                world.updateNeighborsAt(pos, part.getBlock());
            }
            for (BlockPos pos : this.getPosList()) {
                BlockEntity tileEntity = world.getBlockEntity(pos);
                if (!(tileEntity instanceof ReactorPartTile)) continue;
                ReactorPartTile part = (ReactorPartTile)tileEntity;
                part.setBuilt(true);
                part.sync();
            }
            this.built = true;
            this.reactor.sync();
        }
        return false;
    }

    public void shuffle() {
        this.queue.addAll(this.getPosList());
        Collections.shuffle(this.queue);
    }

    public void demolish(Level world) {
        List<BlockPos> list = this.getPosList();
        list.add(this.reactor.getBlockPos());
        list.removeAll(this.queue);
        int count = 0;
        for (BlockPos blockPos : list) {
            if (!world.getBlockState(blockPos).getBlock().equals(this.reactor.getBlock())) continue;
            ++count;
            world.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 3);
        }
        Block.popResource((Level)world, (BlockPos)this.reactor.getBlockPos(), (ItemStack)new ItemStack(this.reactor.getBlock(), count + this.queue.size()));
        world.setBlock(this.reactor.getBlockPos(), Blocks.AIR.defaultBlockState(), 3);
        this.queue.clear();
    }

    public List<BlockPos> getPosList() {
        BlockPos pos = this.reactor.getBlockPos();
        return BlockPos.betweenClosedStream((BlockPos)pos.offset(-1, 0, -1), (BlockPos)pos.offset(1, 3, 1)).map(BlockPos::immutable).filter(pos1 -> !pos1.equals((Object)pos)).collect(Collectors.toList());
    }
}

