/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.tempad.api.context;

import com.teamresourceful.bytecodecs.base.ByteCodec;
import com.teamresourceful.resourcefullib.common.bytecodecs.ExtraByteCodecs;
import earth.terrarium.tempad.TempadKt;
import earth.terrarium.tempad.api.context.ContextType;
import earth.terrarium.tempad.api.context.SyncableContext;
import earth.terrarium.tempad.common.block.WorkstationBE;
import earth.terrarium.tempad.common.utils.ExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001eB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u0016H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0005\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\rX\u0096\u0004\u00a2\u0006\n\n\u0002\b\u0010\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R$\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00168V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001f"}, d2={"Learth/terrarium/tempad/api/context/WorkstationContext;", "Learth/terrarium/tempad/api/context/SyncableContext;", "Lnet/minecraft/core/BlockPos;", "player", "Lnet/minecraft/world/entity/player/Player;", "data", "<init>", "(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/core/BlockPos;)V", "getPlayer", "()Lnet/minecraft/world/entity/player/Player;", "getData", "()Lnet/minecraft/core/BlockPos;", "type", "Learth/terrarium/tempad/api/context/ContextType;", "getType", "()Learth/terrarium/tempad/api/context/ContextType;", "type$1", "workstation", "Learth/terrarium/tempad/common/block/WorkstationBE;", "getWorkstation", "()Learth/terrarium/tempad/common/block/WorkstationBE;", "value", "Lnet/minecraft/world/item/ItemStack;", "stack", "getStack", "()Lnet/minecraft/world/item/ItemStack;", "setStack", "(Lnet/minecraft/world/item/ItemStack;)V", "addStack", "", "Companion", "tempad-1.21.1"})
public final class WorkstationContext
implements SyncableContext<BlockPos> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Player player;
    @NotNull
    private final BlockPos data;
    @NotNull
    private final ContextType<BlockPos> type$1;
    @NotNull
    private static final ContextType<BlockPos> type;

    public WorkstationContext(@NotNull Player player, @NotNull BlockPos data) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.player = player;
        this.data = data;
        this.type$1 = type;
    }

    @NotNull
    public final Player getPlayer() {
        return this.player;
    }

    @Override
    @NotNull
    public BlockPos getData() {
        return this.data;
    }

    @Override
    @NotNull
    public ContextType<BlockPos> getType() {
        return this.type$1;
    }

    @Nullable
    public final WorkstationBE getWorkstation() {
        BlockEntity blockEntity = this.player.level().getBlockEntity(this.getData());
        return blockEntity instanceof WorkstationBE ? (WorkstationBE)blockEntity : null;
    }

    @Override
    @NotNull
    public ItemStack getStack() {
        WorkstationBE workstationBE = this.getWorkstation();
        if (workstationBE == null || (workstationBE = workstationBE.getInventory()) == null || (workstationBE = ExtensionsKt.get((ItemStackHandler)workstationBE, 0)) == null) {
            ItemStack itemStack = ItemStack.EMPTY;
            workstationBE = itemStack;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        }
        return workstationBE;
    }

    @Override
    public void setStack(@NotNull ItemStack value) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            WorkstationBE workstationBE = this.getWorkstation();
            if (workstationBE == null) {
                return;
            }
            WorkstationBE station = workstationBE;
            ExtensionsKt.set(station.getInventory(), 0, value);
            station.setChanged();
            Level level = station.getLevel();
            if (level == null) break block1;
            level.sendBlockUpdated(station.getBlockPos(), station.getBlockState(), station.getBlockState(), 3);
        }
    }

    @Override
    public void addStack(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        this.player.getInventory().placeItemBackInInventory(stack);
    }

    static {
        ResourceLocation resourceLocation = TempadKt.getTempadId("workstation");
        ByteCodec byteCodec2 = ExtraByteCodecs.BLOCK_POS;
        Intrinsics.checkNotNullExpressionValue((Object)byteCodec2, (String)"BLOCK_POS");
        type = new ContextType(resourceLocation, byteCodec2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001f\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Learth/terrarium/tempad/api/context/WorkstationContext$Companion;", "", "<init>", "()V", "type", "Learth/terrarium/tempad/api/context/ContextType;", "Lnet/minecraft/core/BlockPos;", "kotlin.jvm.PlatformType", "getType", "()Learth/terrarium/tempad/api/context/ContextType;", "tempad-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ContextType<BlockPos> getType() {
            return type;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

