/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.tempad.api.tva_device.impl;

import earth.terrarium.tempad.api.ActionType;
import earth.terrarium.tempad.api.tva_device.ChrononHandler;
import earth.terrarium.tempad.common.registries.ModComponentsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R$\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00058V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\f\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\f\u00a8\u0006\u001e"}, d2={"Learth/terrarium/tempad/api/tva_device/impl/TempadChrononHandler;", "Learth/terrarium/tempad/api/tva_device/ChrononHandler;", "stack", "Lnet/minecraft/world/item/ItemStack;", "tempadLimit", "", "timeTwisterLimit", "<init>", "(Lnet/minecraft/world/item/ItemStack;II)V", "getStack", "()Lnet/minecraft/world/item/ItemStack;", "getTempadLimit", "()I", "canExtract", "", "getCanExtract", "()Z", "value", "power", "getPower", "setPower", "(I)V", "maxPower", "getMaxPower", "extract", "amount", "action", "Learth/terrarium/tempad/api/ActionType;", "insert", "Companion", "tempad-1.21.1"})
public final class TempadChrononHandler
implements ChrononHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ItemStack stack;
    private final int tempadLimit;
    private final boolean canExtract;
    private final int maxPower;

    public TempadChrononHandler(@NotNull ItemStack stack, int tempadLimit, int timeTwisterLimit) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        this.stack = stack;
        this.tempadLimit = tempadLimit;
        this.maxPower = this.tempadLimit + (ModComponentsKt.getTwisterEquipped((MutableDataComponentHolder)this.stack) ? timeTwisterLimit : 0);
    }

    @NotNull
    public final ItemStack getStack() {
        return this.stack;
    }

    public final int getTempadLimit() {
        return this.tempadLimit;
    }

    @Override
    public boolean getCanExtract() {
        return this.canExtract;
    }

    @Override
    public int getPower() {
        return ModComponentsKt.getChrononContentTempad((MutableDataComponentHolder)this.stack) + ModComponentsKt.getChrononContentTimeTwister((MutableDataComponentHolder)this.stack);
    }

    public void setPower(int value) {
        TempadChrononHandler $this$_set_power__u24lambda_u240 = this;
        boolean bl = false;
        int diff = value - $this$_set_power__u24lambda_u240.getPower();
        if (diff == 0) {
            return;
        }
        int tempadDiff = RangesKt.coerceAtMost((int)diff, (int)($this$_set_power__u24lambda_u240.tempadLimit - ModComponentsKt.getChrononContentTempad((MutableDataComponentHolder)$this$_set_power__u24lambda_u240.stack)));
        ItemStack itemStack = $this$_set_power__u24lambda_u240.stack;
        ModComponentsKt.setChrononContentTempad((MutableDataComponentHolder)itemStack, ModComponentsKt.getChrononContentTempad((MutableDataComponentHolder)itemStack) + tempadDiff);
        itemStack = $this$_set_power__u24lambda_u240.stack;
        ModComponentsKt.setChrononContentTimeTwister((MutableDataComponentHolder)itemStack, ModComponentsKt.getChrononContentTimeTwister((MutableDataComponentHolder)itemStack) + (diff - tempadDiff));
    }

    @Override
    public int getMaxPower() {
        return this.maxPower;
    }

    @Override
    public int extract(int amount, @NotNull ActionType action) {
        Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
        int extracted = Mth.clamp((int)this.getPower(), (int)0, (int)amount);
        if (action == ActionType.Execute) {
            this.setPower(this.getPower() - extracted);
        }
        return extracted;
    }

    @Override
    public int insert(int amount, @NotNull ActionType action) {
        Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
        int inserted = Mth.clamp((int)amount, (int)0, (int)(this.getMaxPower() - this.getPower()));
        if (action == ActionType.Execute) {
            this.setPower(this.getPower() + inserted);
        }
        return inserted;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t\u00a8\u0006\u000b"}, d2={"Learth/terrarium/tempad/api/tva_device/impl/TempadChrononHandler$Companion;", "", "<init>", "()V", "create", "Learth/terrarium/tempad/api/tva_device/impl/TempadChrononHandler;", "stack", "Lnet/minecraft/world/item/ItemStack;", "tempadLimit", "", "timeTwisterLimit", "tempad-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final TempadChrononHandler create(@NotNull ItemStack stack, int tempadLimit, int timeTwisterLimit) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            if (tempadLimit + timeTwisterLimit <= 0) {
                return null;
            }
            return new TempadChrononHandler(stack, tempadLimit, timeTwisterLimit);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

