/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.tempad.common.block;

import com.mojang.authlib.GameProfile;
import earth.terrarium.tempad.Tempad;
import earth.terrarium.tempad.api.app.AppRegistry;
import earth.terrarium.tempad.api.app.TempadApp;
import earth.terrarium.tempad.api.context.WorkstationContext;
import earth.terrarium.tempad.common.block.WorkstationBE;
import earth.terrarium.tempad.common.registries.ModApps;
import earth.terrarium.tempad.common.registries.ModAttachmentsKt;
import earth.terrarium.tempad.common.registries.ModBlocks;
import earth.terrarium.tempad.common.registries.ModComponentsKt;
import earth.terrarium.tempad.common.utils.ExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.attachment.AttachmentHolder;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 /2\u00020\u0001:\u0001/B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J \u0010\u0010\u001a\u00020\u00112\u0016\u0010\u0012\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0013H\u0014J8\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000bH\u0014J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J(\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020!H\u0014J\u0016\u0010\"\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010#\u001a\u00020\u00162\u0006\u0010\u0006\u001a\u00020\u0007J8\u0010$\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u00012\u0006\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020(H\u0014J(\u0010)\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J0\u0010*\u001a\u00020+2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010,\u001a\u00020-2\u0006\u0010\b\u001a\u00020.2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u00060"}, d2={"Learth/terrarium/tempad/common/block/WorkstationChildBlock;", "Lnet/minecraft/world/level/block/Block;", "<init>", "()V", "useWithoutItem", "Lnet/minecraft/world/InteractionResult;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "player", "Lnet/minecraft/world/entity/player/Player;", "hitResult", "Lnet/minecraft/world/phys/BlockHitResult;", "createBlockStateDefinition", "", "builder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "updateShape", "facing", "Lnet/minecraft/core/Direction;", "facingState", "Lnet/minecraft/world/level/LevelAccessor;", "currentPos", "neighborPos", "getRenderShape", "Lnet/minecraft/world/level/block/RenderShape;", "getShape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "Lnet/minecraft/world/level/BlockGetter;", "context", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "getPos", "relativeDir", "neighborChanged", "block", "fromPos", "isMoving", "", "playerWillDestroy", "getCloneItemStack", "Lnet/minecraft/world/item/ItemStack;", "target", "Lnet/minecraft/world/phys/HitResult;", "Lnet/minecraft/world/level/LevelReader;", "Companion", "tempad-1.21.1"})
public final class WorkstationChildBlock
extends Block {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final VoxelShape NORTH_SHAPE;
    @NotNull
    private static final VoxelShape SOUTH_SHAPE;
    @NotNull
    private static final VoxelShape WEST_SHAPE;
    @NotNull
    private static final VoxelShape EAST_SHAPE;

    public WorkstationChildBlock() {
        super(BlockBehaviour.Properties.of().strength(3.0f, 1200.0f));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.TRIGGERED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        TempadApp<?> tempadApp;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockPos storagePos = this.getPos(state, pos);
        BlockEntity blockEntity = level.getBlockEntity(storagePos);
        WorkstationBE workstationBE = blockEntity instanceof WorkstationBE ? (WorkstationBE)blockEntity : null;
        if (workstationBE == null) {
            return InteractionResult.PASS;
        }
        WorkstationBE storageBE = workstationBE;
        WorkstationContext ctx2 = new WorkstationContext(player, storagePos);
        ItemStack stack = ExtensionsKt.get(storageBE.getInventory(), 0);
        if (stack.isEmpty()) {
            return InteractionResult.PASS;
        }
        if (ModAttachmentsKt.getOwner((AttachmentHolder)storageBE) == null) {
            ModAttachmentsKt.setOwner((AttachmentHolder)storageBE, player.getGameProfile());
        } else if (ModComponentsKt.getLocked((MutableDataComponentHolder)stack)) {
            GameProfile gameProfile = ModAttachmentsKt.getOwner((AttachmentHolder)storageBE);
            if (!Intrinsics.areEqual((Object)(gameProfile != null ? gameProfile.getId() : null), (Object)player.getGameProfile().getId())) {
                Object[] objectArray = new Object[]{this.getName()};
                player.displayClientMessage((Component)Component.translatable((String)"error.tempad.block_locked", (Object[])objectArray).withColor(Tempad.Companion.getORANGE().getValue()), true);
                return InteractionResult.FAIL;
            }
        }
        if ((tempadApp = AppRegistry.INSTANCE.get(ModComponentsKt.getDefaultApp((MutableDataComponentHolder)stack), ctx2, true)) == null) {
            tempadApp = AppRegistry.INSTANCE.get(ModApps.INSTANCE.getPortalSetup(), ctx2, true);
        }
        Intrinsics.checkNotNull(tempadApp);
        tempadApp.openMenu((ServerPlayer)player);
        return InteractionResult.SUCCESS;
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{BlockStateProperties.HORIZONTAL_FACING};
        StateDefinition.Builder builder2 = builder.add(propertyArray);
        propertyArray = new Property[]{BlockStateProperties.TRIGGERED};
        builder2.add(propertyArray);
    }

    @NotNull
    protected BlockState updateShape(@NotNull BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor level, @NotNull BlockPos currentPos, @NotNull BlockPos neighborPos) {
        BlockState blockState;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)facing, (String)"facing");
        Intrinsics.checkNotNullParameter((Object)facingState, (String)"facingState");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)currentPos, (String)"currentPos");
        Intrinsics.checkNotNullParameter((Object)neighborPos, (String)"neighborPos");
        if (facing == this.relativeDir(state) && Intrinsics.areEqual((Object)facingState.getBlock(), (Object)Blocks.AIR)) {
            BlockState blockState2 = Blocks.AIR.defaultBlockState();
            Intrinsics.checkNotNull((Object)blockState2);
            blockState = blockState2;
        } else {
            BlockState blockState3 = super.updateShape(state, facing, facingState, level, currentPos, neighborPos);
            Intrinsics.checkNotNull((Object)blockState3);
            blockState = blockState3;
        }
        return blockState;
    }

    @NotNull
    protected RenderShape getRenderShape(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return RenderShape.MODEL;
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Direction direction = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        return switch (direction == null ? -1 : WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1 -> NORTH_SHAPE;
            case 2 -> SOUTH_SHAPE;
            case 3 -> WEST_SHAPE;
            case 4 -> EAST_SHAPE;
            default -> NORTH_SHAPE;
        };
    }

    @NotNull
    public final BlockPos getPos(@NotNull BlockState state, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        BlockPos blockPos = pos.relative(this.relativeDir(state));
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"relative(...)");
        return blockPos;
    }

    @NotNull
    public final Direction relativeDir(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Direction direction = Direction.fromYRot((double)((double)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot() + 90.0));
        Intrinsics.checkNotNullExpressionValue((Object)direction, (String)"fromYRot(...)");
        return direction;
    }

    protected void neighborChanged(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block block, @NotNull BlockPos fromPos, boolean isMoving) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)fromPos, (String)"fromPos");
        BlockPos ogBlock = this.getPos(state, pos);
        boolean neighborPowered = level.hasNeighborSignal(pos) || level.hasNeighborSignal(pos.above()) || level.hasNeighborSignal(ogBlock);
        BlockPos controllerPos = this.getPos(state, pos);
        BlockEntity blockEntity = level.getBlockEntity(controllerPos);
        WorkstationBE workstationBE = blockEntity instanceof WorkstationBE ? (WorkstationBE)blockEntity : null;
        if (workstationBE == null) {
            return;
        }
        WorkstationBE blockEntity2 = workstationBE;
        if (neighborPowered && !blockEntity2.getActive()) {
            blockEntity2.activateLeft();
        } else if (!neighborPowered && blockEntity2.getActive()) {
            blockEntity2.deactivateLeft();
        }
    }

    @NotNull
    public BlockState playerWillDestroy(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!level.isClientSide) {
            BlockPos blockpos = this.getPos(state, pos);
            BlockState blockstate = level.getBlockState(blockpos);
            Direction dir = (Direction)blockstate.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            if (blockstate.is((Block)ModBlocks.INSTANCE.getWorkstation()) && state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING) == dir) {
                level.destroyBlock(blockpos, !player.isCreative());
                level.levelEvent(player, 2001, blockpos, Block.getId((BlockState)blockstate));
            }
        }
        BlockState blockState = super.playerWillDestroy(level, pos, state, player);
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"playerWillDestroy(...)");
        return blockState;
    }

    @NotNull
    public ItemStack getCloneItemStack(@NotNull BlockState state, @NotNull HitResult target, @NotNull LevelReader level, @NotNull BlockPos pos, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return new ItemStack((ItemLike)ModBlocks.INSTANCE.getWorkstation());
    }

    static {
        VoxelShape voxelShape = Shapes.or((VoxelShape)Block.box((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)1.0, (double)2.0, (double)0.0, (double)15.0, (double)11.0, (double)10.0));
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"or(...)");
        NORTH_SHAPE = voxelShape;
        VoxelShape voxelShape2 = Shapes.or((VoxelShape)Block.box((double)1.0, (double)0.0, (double)0.0, (double)15.0, (double)2.0, (double)16.0), (VoxelShape)Block.box((double)1.0, (double)2.0, (double)6.0, (double)15.0, (double)11.0, (double)16.0));
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape2, (String)"or(...)");
        SOUTH_SHAPE = voxelShape2;
        VoxelShape voxelShape3 = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)2.0, (double)15.0), (VoxelShape)Block.box((double)0.0, (double)2.0, (double)1.0, (double)10.0, (double)11.0, (double)15.0));
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape3, (String)"or(...)");
        WEST_SHAPE = voxelShape3;
        VoxelShape voxelShape4 = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)2.0, (double)15.0), (VoxelShape)Block.box((double)6.0, (double)2.0, (double)1.0, (double)16.0, (double)11.0, (double)15.0));
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape4, (String)"or(...)");
        EAST_SHAPE = voxelShape4;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007\u00a8\u0006\u000e"}, d2={"Learth/terrarium/tempad/common/block/WorkstationChildBlock$Companion;", "", "<init>", "()V", "NORTH_SHAPE", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "getNORTH_SHAPE", "()Lnet/minecraft/world/phys/shapes/VoxelShape;", "SOUTH_SHAPE", "getSOUTH_SHAPE", "WEST_SHAPE", "getWEST_SHAPE", "EAST_SHAPE", "getEAST_SHAPE", "tempad-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VoxelShape getNORTH_SHAPE() {
            return NORTH_SHAPE;
        }

        @NotNull
        public final VoxelShape getSOUTH_SHAPE() {
            return SOUTH_SHAPE;
        }

        @NotNull
        public final VoxelShape getWEST_SHAPE() {
            return WEST_SHAPE;
        }

        @NotNull
        public final VoxelShape getEAST_SHAPE() {
            return EAST_SHAPE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=50)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.NORTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.SOUTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.WEST.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.EAST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

