/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.tempad.common.block.timedoor_marker;

import com.mojang.authlib.GameProfile;
import earth.terrarium.tempad.api.locations.NamedGlobalVec3;
import earth.terrarium.tempad.common.registries.ModAttachments;
import earth.terrarium.tempad.common.registries.ModAttachmentsKt;
import earth.terrarium.tempad.common.utils.ExtensionsKt;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.attachment.AttachmentHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u00012\u00020\u0002B#\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H&J\u0010\u0010(\u001a\u00020\f2\u0006\u0010&\u001a\u00020)H&J\u0018\u0010*\u001a\u00020%2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0014J\u0018\u0010/\u001a\u00020%2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0014J\u0010\u00100\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\b\u00101\u001a\u000202H\u0016J\n\u00103\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u00104\u001a\u00020\u0012H\u0016R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R$\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00128F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u00065"}, d2={"Learth/terrarium/tempad/common/block/timedoor_marker/AbstractMarkerBe;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lnet/minecraft/world/Nameable;", "block", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "locked", "", "getLocked", "()Z", "setLocked", "(Z)V", "value", "Lnet/minecraft/network/chat/Component;", "posName", "getPosName", "()Lnet/minecraft/network/chat/Component;", "setPosName", "(Lnet/minecraft/network/chat/Component;)V", "landingPosition", "Lnet/minecraft/world/phys/Vec3;", "getLandingPosition", "()Lnet/minecraft/world/phys/Vec3;", "landingAngle", "", "getLandingAngle", "()F", "namedGlobalVec3", "Learth/terrarium/tempad/api/locations/NamedGlobalVec3;", "getNamedGlobalVec3", "()Learth/terrarium/tempad/api/locations/NamedGlobalVec3;", "openScreen", "", "player", "Lnet/minecraft/world/entity/player/Player;", "canAccess", "Lcom/mojang/authlib/GameProfile;", "loadAdditional", "tag", "Lnet/minecraft/nbt/CompoundTag;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "saveAdditional", "getUpdateTag", "getUpdatePacket", "Lnet/minecraft/network/protocol/game/ClientboundBlockEntityDataPacket;", "getCustomName", "getName", "tempad-1.21.1"})
@SourceDebugExtension(value={"SMAP\nAbstractMarkerBe.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractMarkerBe.kt\nearth/terrarium/tempad/common/block/timedoor_marker/AbstractMarkerBe\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,72:1\n1#2:73\n*E\n"})
public abstract class AbstractMarkerBe
extends BlockEntity
implements Nameable {
    private boolean locked;

    public AbstractMarkerBe(@NotNull BlockEntityType<?> block, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(block, pos, state);
        this.locked = true;
    }

    public final boolean getLocked() {
        return this.locked;
    }

    public final void setLocked(boolean bl) {
        this.locked = bl;
    }

    @NotNull
    public final Component getPosName() {
        Optional optional = this.getExistingData(ModAttachments.INSTANCE.getName());
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getExistingData(...)");
        Component component = (Component)OptionalsKt.getOrNull((Optional)optional);
        if (component == null) {
            MutableComponent mutableComponent = this.getBlockState().getBlock().getName();
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"getName(...)");
            component = (Component)mutableComponent;
        }
        return component;
    }

    public final void setPosName(@NotNull Component value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.setData(ModAttachments.INSTANCE.getName(), value);
    }

    @NotNull
    public Vec3 getLandingPosition() {
        Vec3 vec3;
        Vec3 relative = this.worldPosition.getBottomCenter().relative((Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING), 1.0);
        if (((Boolean)this.getBlockState().getValue((Property)BlockStateProperties.UP)).booleanValue()) {
            Vec3 vec32 = relative.add(0.0, 0.5, 0.0);
            vec3 = vec32;
            Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"add(...)");
        } else {
            Vec3 vec33 = relative.add(0.0, -2.0, 0.0);
            vec3 = vec33;
            Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"add(...)");
        }
        return vec3;
    }

    public float getLandingAngle() {
        return ExtensionsKt.getFacingAngle(this);
    }

    @NotNull
    public final NamedGlobalVec3 getNamedGlobalVec3() {
        Component component = this.getPosName();
        Vec3 vec3 = this.getLandingPosition();
        Level level = this.level;
        Intrinsics.checkNotNull((Object)level);
        ResourceKey resourceKey = level.dimension();
        Intrinsics.checkNotNullExpressionValue((Object)resourceKey, (String)"dimension(...)");
        return new NamedGlobalVec3(component, vec3, (ResourceKey<Level>)resourceKey, this.getLandingAngle(), ModAttachmentsKt.getColor((AttachmentHolder)this));
    }

    public abstract void openScreen(@NotNull Player var1);

    public abstract boolean canAccess(@NotNull GameProfile var1);

    protected void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.loadAdditional(tag, registries);
        this.locked = tag.getBoolean("Locked");
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.saveAdditional(tag, registries);
        tag.putBoolean("Locked", this.locked);
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider registries) {
        CompoundTag compoundTag;
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        CompoundTag $this$getUpdateTag_u24lambda_u240 = compoundTag = new CompoundTag();
        boolean bl = false;
        this.saveAdditional($this$getUpdateTag_u24lambda_u240, registries);
        return compoundTag;
    }

    @NotNull
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        ClientboundBlockEntityDataPacket clientboundBlockEntityDataPacket = ClientboundBlockEntityDataPacket.create((BlockEntity)this);
        Intrinsics.checkNotNullExpressionValue((Object)clientboundBlockEntityDataPacket, (String)"create(...)");
        return clientboundBlockEntityDataPacket;
    }

    @Nullable
    public Component getCustomName() {
        Optional optional = this.getExistingData(ModAttachments.INSTANCE.getName());
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getExistingData(...)");
        return (Component)OptionalsKt.getOrNull((Optional)optional);
    }

    @NotNull
    public Component getName() {
        return this.getPosName();
    }
}

