/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.tempad.common.config;

import com.teamresourceful.resourcefulconfig.api.annotations.Category;
import com.teamresourceful.resourcefulconfig.api.annotations.Comment;
import com.teamresourceful.resourcefulconfig.api.annotations.Config;
import com.teamresourceful.resourcefulconfig.api.annotations.ConfigEntry;
import com.teamresourceful.resourcefulconfig.api.annotations.ConfigInfo;
import com.teamresourceful.resourcefulconfig.api.types.entries.Observable;

@ConfigInfo(icon="watch", title="Tempad", description="Adds a device that allows you to teleport to any location stored on your Tempad.", links={@ConfigInfo.Link(text="CurseForge", value="https://www.curseforge.com/minecraft/mc-mods/tempad", icon="curseforge"), @ConfigInfo.Link(text="Modrinth", value="https://modrinth.com/mod/tempad", icon="modrinth"), @ConfigInfo.Link(text="GitHub", value="https://modrinth.com/mod/tempad", icon="github"), @ConfigInfo.Link(text="Discord", value="https://discord.terrarium.earth", icon="gamepad-2")})
@ConfigInfo.Color(value="#ff6f00")
@Config(value="tempad", categories={TimeDoor.class, Chronometer.class, ChrononGenerator.class, Cell.class, Battery.class, RudimentaryTempad.class, Tempad.class, TimeTwister.class, Metronome.class, Chronomark.class})
public final class CommonConfig {
    @ConfigEntry(id="allow_interdimensional_travel")
    @Comment(value="Whether or not Time Doors are allowed to be opened to dimensions other than the one they are in.")
    public static boolean allowInterdimensionalTravel = true;
    @ConfigEntry(id="allow_intradimensional_travel")
    @Comment(value="Whether or not Time Doors are allowed to be opened to the same dimension they are in.")
    public static boolean allowIntradimensionalTravel = true;
    @ConfigEntry(id="allow_location_saving")
    @Comment(value="Whether or not locations can be saved to the Tempad.")
    public static boolean allowLocationSaving = true;
    @ConfigEntry(id="max_history_size")
    @Comment(value="The maximum amount of locations that the Time Twister will save location history for.")
    public static int maxHistorySize = 512;

    @Category(value="chronomark")
    public static final class Chronomark {
        @ConfigEntry(id="max_offset")
        @Comment(value="The maximum range that you can set the portal position to be")
        public static Observable<Integer> maxOffsetChronomark = Observable.of((Object)5);
    }

    @Category(value="chronon_battery")
    public static final class Battery {
        @ConfigEntry(id="capacity")
        @Comment(value="The amount of fuel that the Battery can store.")
        public static Observable<Integer> capacityBattery = Observable.of((Object)4000);
    }

    @Category(value="chronon_cell")
    public static final class Cell {
        @ConfigEntry(id="capacity")
        @Comment(value="The amount of fuel that the Capacitor can store.")
        public static Observable<Integer> capacityCapacitor = Observable.of((Object)2000);
    }

    @Category(value="metronome")
    public static final class Metronome {
        @ConfigEntry(id="capacity")
        @Comment(value="The amount of fuel that the Chronometer can store.")
        public static Observable<Integer> capacityMetronome = Observable.of((Object)6000);
        @ConfigEntry(id="generation_rate")
        @Comment(value="The amount of time it takes for the Chronometer to generate 1 chronon (in ticks).")
        public static int generationRate = 24;
        @ConfigEntry(id="generation_amount")
        @Comment(value="The number of chronons generated everytime the Chronometer does a tick of work.")
        public static int generationAmount = 1;
        @ConfigEntry(id="should_scale_generation")
        @Comment(value="Whether or not the number of chronons generated per cycle is scaled to the number of metronomes placed")
        public static Observable<Boolean> scaleGeneration = Observable.of((Object)true);
        @ConfigEntry(id="transfer_rate")
        @Comment(value="The number of chronons thats transferred to each internal slot or to a neighboring block per tick.")
        public static int transferRate = 20;
        @ConfigEntry(id="jump_start_amount")
        @Comment(value="Whether or not the number of chronons generated per cycle is scaled to the number of metronomes placed")
        public static int jumpStartAmount = 2000;
    }

    @Category(value="chronometer")
    public static final class Chronometer {
        @ConfigEntry(id="capacity")
        @Comment(value="The amount of fuel that the Chronometer can store.")
        public static Observable<Integer> capacityChronometer = Observable.of((Object)0);
        @ConfigEntry(id="generation_rate")
        @Comment(value="The amount of time it takes for the Chronometer to generate 1 chronon (in ticks).")
        public static int generationRate = 36;
        @ConfigEntry(id="generation_amount")
        @Comment(value="The amount of chronons generated everytime the Chronometer does a tick of work.")
        public static int generationAmount = 1;
    }

    @Category(value="chronon_generator")
    public static final class ChrononGenerator {
        @ConfigEntry(id="capacity")
        @Comment(value="The amount of fuel that the Chronometer can store.")
        public static Observable<Integer> capacitorGenerator = Observable.of((Object)0);
        @ConfigEntry(id="generation_rate")
        @Comment(value="The amount of time it takes for the Chronometer to generate 1 chronon (in ticks).")
        public static int generationRate = 48;
        @ConfigEntry(id="generation_amount")
        @Comment(value="The amount of chronons generated everytime the Chronometer does a tick of work.")
        public static int generationAmount = 1;
    }

    @Category(value="time_twister")
    public static final class TimeTwister {
        @ConfigEntry(id="capacity")
        @Comment(value="The amount of fuel that the Time Twister can store.")
        public static Observable<Integer> capacityTimeTwister = Observable.of((Object)3000);
        @ConfigEntry(id="cost_to_backtrack")
        @Comment(value="The cost that the Time Twister consumes to backtrack to a location")
        public static int costToBacktrack = 500;
    }

    @Category(value="tempad")
    public static final class Tempad {
        @ConfigEntry(id="capacity")
        @Comment(value="The amount of fuel that the Tempad can store (without the time twister being installed).")
        public static Observable<Integer> capacityTempad = Observable.of((Object)6000);
        @ConfigEntry(id="max_offset")
        @Comment(value="The maximum range that you can set the portal position to be")
        public static Observable<Integer> maxOffsetTempad = Observable.of((Object)5);
    }

    @Category(value="timedoor_projector")
    public static final class RudimentaryTempad {
        @ConfigEntry(id="capacity")
        @Comment(value="The amount of fuel that the Rudimentary Tempad can store.")
        public static Observable<Integer> capacityRudi = Observable.of((Object)4000);
    }

    @Category(value="timedoor")
    public static final class TimeDoor {
        @ConfigEntry(id="placement_distance")
        @Comment(value="The distance between the Time Door and the player when placed.")
        public static int placementDistance = 3;
        @ConfigEntry(id="log_when_open")
        @Comment(value="Whether or not the Time Door should log when it is opened in the console.")
        public static boolean logWhenOpen = false;
        @ConfigEntry(id="cost_per_door")
        @Comment(value="The cost that any device requires to open a timedoor for 10 seconds")
        public static int costPerDoor = 1000;
        @ConfigEntry(id="cost_to_persist")
        @Comment(value="The cost that any device requires to open add 1 second to a timedoor's life")
        public static int costToPersist = 10;
        @ConfigEntry(id="time_in_world")
        @Comment(value="The amount of time in ticks that a Time Door will remain open")
        public static int timeInWorld = 200;
    }
}

