/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.tempad.common.location_handlers;

import com.mojang.authlib.GameProfile;
import earth.terrarium.tempad.Tempad;
import earth.terrarium.tempad.TempadKt;
import earth.terrarium.tempad.api.context.ContextRegistry;
import earth.terrarium.tempad.api.locations.IndirectLocation;
import earth.terrarium.tempad.api.locations.LocationGetter;
import earth.terrarium.tempad.api.locations.LocationHandler;
import earth.terrarium.tempad.api.locations.NamedGlobalVec3;
import earth.terrarium.tempad.api.locations.NamedGlobalVec3Kt;
import earth.terrarium.tempad.api.player_access.PlayerAccess;
import earth.terrarium.tempad.api.player_access.PlayerAccessKt;
import earth.terrarium.tempad.api.tva_device.UpgradeHandler;
import earth.terrarium.tempad.common.registries.ModItems;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0011\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000eH\u0096\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0014\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR \u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Learth/terrarium/tempad/common/location_handlers/PlayerHandler;", "Learth/terrarium/tempad/api/locations/LocationHandler;", "player", "Lcom/mojang/authlib/GameProfile;", "upgrades", "Learth/terrarium/tempad/api/tva_device/UpgradeHandler;", "<init>", "(Lcom/mojang/authlib/GameProfile;Learth/terrarium/tempad/api/tva_device/UpgradeHandler;)V", "getPlayer", "()Lcom/mojang/authlib/GameProfile;", "getUpgrades", "()Learth/terrarium/tempad/api/tva_device/UpgradeHandler;", "locations", "", "Ljava/util/UUID;", "Learth/terrarium/tempad/api/locations/NamedGlobalVec3;", "getLocations", "()Ljava/util/Map;", "minusAssign", "", "locationId", "getSerializable", "Learth/terrarium/tempad/api/locations/LocationGetter;", "Companion", "tempad-1.21.1"})
@SourceDebugExtension(value={"SMAP\nPlayerHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerHandler.kt\nearth/terrarium/tempad/common/location_handlers/PlayerHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n774#2:65\n865#2,2:66\n774#2:68\n865#2,2:69\n1187#2,2:71\n1261#2,4:73\n*S KotlinDebug\n*F\n+ 1 PlayerHandler.kt\nearth/terrarium/tempad/common/location_handlers/PlayerHandler\n*L\n45#1:65\n45#1:66,2\n46#1:68\n46#1:69,2\n47#1:71,2\n47#1:73,4\n*E\n"})
public final class PlayerHandler
implements LocationHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GameProfile player;
    @NotNull
    private final UpgradeHandler upgrades;
    @NotNull
    private static final ResourceLocation ID = TempadKt.getTempadId("player");

    public PlayerHandler(@NotNull GameProfile player, @NotNull UpgradeHandler upgrades) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)upgrades, (String)"upgrades");
        this.player = player;
        this.upgrades = upgrades;
    }

    @NotNull
    public final GameProfile getPlayer() {
        return this.player;
    }

    @NotNull
    public final UpgradeHandler getUpgrades() {
        return this.upgrades;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<UUID, NamedGlobalVec3> getLocations() {
        Map map;
        if (!this.upgrades.contains(ModItems.INSTANCE.getPlayerKey())) {
            return MapsKt.emptyMap();
        }
        MinecraftServer minecraftServer = Tempad.Companion.getServer();
        if (minecraftServer != null) {
            void $this$associateTo$iv$iv;
            ServerPlayer it;
            Iterable $this$filterTo$iv$iv;
            MinecraftServer server = minecraftServer;
            boolean bl = false;
            List list = server.getPlayerList().getPlayers();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayers(...)");
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (ServerPlayer)element$iv$iv;
                boolean bl2 = false;
                if (!(!Intrinsics.areEqual((Object)it.getUUID(), (Object)this.player.getId()) && !it.isSpectator())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (ServerPlayer)element$iv$iv;
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)it);
                if (!(ContextRegistry.INSTANCE.locate((Player)it, (Function1<? super ItemStack, Boolean>)((Function1)arg_0 -> PlayerHandler._get_locations_$lambda$4$lambda$2$lambda$1(server, it, this, arg_0))) != null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$associate$iv = (List)destination$iv$iv;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            destination$iv$iv = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv2;
                ServerPlayer it2 = (ServerPlayer)element$iv$iv;
                boolean bl4 = false;
                UUID uUID = it2.getUUID();
                Intrinsics.checkNotNull((Object)it2);
                Pair pair = TuplesKt.to((Object)uUID, (Object)NamedGlobalVec3Kt.getNamedGlobalVec3((Player)it2));
                map2.put(pair.getFirst(), pair.getSecond());
            }
            map = destination$iv$iv2;
        } else {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    @Override
    public void minusAssign(@NotNull UUID locationId) {
        Intrinsics.checkNotNullParameter((Object)locationId, (String)"locationId");
    }

    @Override
    @Nullable
    public LocationGetter getSerializable(@NotNull UUID locationId) {
        Intrinsics.checkNotNullParameter((Object)locationId, (String)"locationId");
        MinecraftServer minecraftServer = Tempad.Companion.getServer();
        if (minecraftServer == null || (minecraftServer = minecraftServer.getPlayerList()) == null || (minecraftServer = minecraftServer.getPlayer(locationId)) == null || (minecraftServer = minecraftServer.getGameProfile()) == null) {
            return null;
        }
        MinecraftServer pos = minecraftServer;
        Object[] objectArray = new Object[]{Component.literal((String)pos.getName()).withStyle(ChatFormatting.AQUA)};
        MutableComponent mutableComponent = Component.translatable((String)"locations.tempad.player", (Object[])objectArray).withStyle(ChatFormatting.GRAY);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"withStyle(...)");
        return new IndirectLocation(this.player, (Component)mutableComponent, ID, locationId);
    }

    private static final boolean _get_locations_$lambda$4$lambda$2$lambda$1(MinecraftServer $server, ServerPlayer $it, PlayerHandler this$0, ItemStack stack) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        PlayerAccess playerAccess = PlayerAccessKt.getPlayerAccess(stack);
        if (playerAccess != null) {
            ServerLevel serverLevel = $server.overworld();
            Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"overworld(...)");
            Level level = (Level)serverLevel;
            GameProfile gameProfile = $it.getGameProfile();
            Intrinsics.checkNotNullExpressionValue((Object)gameProfile, (String)"getGameProfile(...)");
            bl = playerAccess.canAccess(level, gameProfile, this$0.player);
        } else {
            bl = false;
        }
        return bl;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Learth/terrarium/tempad/common/location_handlers/PlayerHandler$Companion;", "", "<init>", "()V", "ID", "Lnet/minecraft/resources/ResourceLocation;", "getID", "()Lnet/minecraft/resources/ResourceLocation;", "tempad-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceLocation getID() {
            return ID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

