/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.chromacarvings.datagen;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import cy.jdkdigital.chromacarvings.ChromaCarvings;
import cy.jdkdigital.chromacarvings.registry.Registrator;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.data.models.model.DelegatedModel;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockModelProvider
implements DataProvider {
    protected final PackOutput packOutput;
    protected final Map<ResourceLocation, Supplier<JsonElement>> models = new HashMap<ResourceLocation, Supplier<JsonElement>>();

    public BlockModelProvider(PackOutput packOutput) {
        this.packOutput = packOutput;
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        HashMap blockModels = Maps.newHashMap();
        Consumer<BlockStateGenerator> blockStateOutput = blockStateGenerator -> {
            Block block = blockStateGenerator.getBlock();
            BlockStateGenerator blockstategenerator = blockModels.put(block, blockStateGenerator);
            if (blockstategenerator != null) {
                throw new IllegalStateException("Duplicate blockstate definition for " + String.valueOf(block));
            }
        };
        HashMap itemModels = Maps.newHashMap();
        BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput = (resourceLocation, elementSupplier) -> {
            Supplier supplier = itemModels.put(resourceLocation, elementSupplier);
            if (supplier != null) {
                throw new IllegalStateException("Duplicate model definition for " + String.valueOf(resourceLocation));
            }
        };
        ModelGenerator generator = new ModelGenerator();
        try {
            generator.registerStatesAndModels(blockStateOutput, modelOutput);
        }
        catch (Exception e) {
            ChromaCarvings.LOGGER.error("Error registering states and models", (Throwable)e);
        }
        Registrator.PUMPKINS.forEach((dyeColor, holder) -> this.addBlockItemParentModel((Block)holder.get(), "", "", itemModels));
        Registrator.CARVED_PUMPKINS.forEach((dyeColor, holder) -> this.addBlockItemParentModel((Block)holder.get(), "", "", itemModels));
        Registrator.JACKOS.forEach((dyeColor, holder) -> this.addBlockItemParentModel((Block)holder.get(), "", "", itemModels));
        PackOutput.PathProvider blockstatePathProvider = this.packOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "blockstates");
        PackOutput.PathProvider modelPathProvider = this.packOutput.createPathProvider(PackOutput.Target.RESOURCE_PACK, "models");
        ArrayList output = new ArrayList();
        blockModels.forEach((block, supplier) -> output.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)((JsonElement)supplier.get()), (Path)blockstatePathProvider.json(BuiltInRegistries.BLOCK.getKey(block)))));
        itemModels.forEach((rLoc, supplier) -> output.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)((JsonElement)supplier.get()), (Path)modelPathProvider.json(rLoc))));
        return CompletableFuture.allOf((CompletableFuture[])output.toArray(CompletableFuture[]::new));
    }

    private void addItemModel(Item item, Supplier<JsonElement> supplier, Map<ResourceLocation, Supplier<JsonElement>> itemModels) {
        ResourceLocation resourcelocation;
        if (item != null && !itemModels.containsKey(resourcelocation = ModelLocationUtils.getModelLocation((Item)item))) {
            itemModels.put(resourcelocation, supplier);
        }
    }

    private void addBlockItemParentModel(Block block, String prefix, String suffix, Map<ResourceLocation, Supplier<JsonElement>> itemModels) {
        Item item = (Item)Item.BY_BLOCK.get(block);
        if (item != null) {
            ResourceLocation rl = BuiltInRegistries.BLOCK.getKey((Object)block);
            this.addItemParentModel(item, rl, "block/" + prefix, suffix, itemModels);
        }
    }

    private void addItemParentModel(Item item, ResourceLocation rl, String prefix, String suffix, Map<ResourceLocation, Supplier<JsonElement>> itemModels) {
        this.addItemModel(item, (Supplier<JsonElement>)new DelegatedModel(ResourceLocation.fromNamespaceAndPath((String)rl.getNamespace(), (String)(prefix + rl.getPath() + suffix))), itemModels);
    }

    public String getName() {
        return "Chroma Carvings Blockstate and Model generator";
    }

    static class ModelGenerator {
        Consumer<BlockStateGenerator> blockStateOutput;
        BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput;

        ModelGenerator() {
        }

        protected void registerStatesAndModels(Consumer<BlockStateGenerator> blockStateOutput, BiConsumer<ResourceLocation, Supplier<JsonElement>> modelOutput) {
            this.blockStateOutput = blockStateOutput;
            this.modelOutput = modelOutput;
            Registrator.PUMPKINS.forEach((dyeColor, block) -> this.createPumpkin((Block)block.get()));
            Registrator.CARVED_PUMPKINS.forEach((dyeColor, block) -> this.createPumpkinVariant((Block)block.get(), (DyeColor)dyeColor));
            Registrator.JACKOS.forEach((dyeColor, block) -> this.createPumpkinVariant((Block)block.get(), (DyeColor)dyeColor));
        }

        private void createPumpkin(Block block) {
            ModelTemplate pumpkinBaseModel = new ModelTemplate(Optional.of(ModelLocationUtils.getModelLocation((Block)Blocks.PUMPKIN)), Optional.empty(), new TextureSlot[]{TextureSlot.END, TextureSlot.SIDE});
            TextureMapping mapping = new TextureMapping().put(TextureSlot.END, TextureMapping.getBlockTexture((Block)block, (String)"_top")).put(TextureSlot.SIDE, TextureMapping.getBlockTexture((Block)block, (String)"_side"));
            ResourceLocation model = pumpkinBaseModel.create(block, mapping, this.modelOutput);
            this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)block, (Variant)Variant.variant().with(VariantProperties.MODEL, (Object)model)));
        }

        private void createPumpkinVariant(Block pumpkinBlock, DyeColor color) {
            TextureMapping textureMapping = new TextureMapping().put(TextureSlot.SIDE, ResourceLocation.fromNamespaceAndPath((String)"chromacarvings", (String)("block/" + color.getSerializedName() + "_pumpkin_side"))).put(TextureSlot.END, ResourceLocation.fromNamespaceAndPath((String)"chromacarvings", (String)("block/" + color.getSerializedName() + "_pumpkin_top")));
            ResourceLocation resourcelocation = ModelTemplates.CUBE_ORIENTABLE.create(pumpkinBlock, textureMapping.copyAndUpdate(TextureSlot.FRONT, TextureMapping.getBlockTexture((Block)pumpkinBlock)), this.modelOutput);
            this.blockStateOutput.accept((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)pumpkinBlock, (Variant)Variant.variant().with(VariantProperties.MODEL, (Object)resourcelocation)).with(ModelGenerator.createHorizontalFacingDispatch()));
        }

        private static PropertyDispatch createHorizontalFacingDispatch() {
            return PropertyDispatch.property((Property)BlockStateProperties.HORIZONTAL_FACING).select((Comparable)Direction.EAST, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90)).select((Comparable)Direction.SOUTH, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180)).select((Comparable)Direction.WEST, Variant.variant().with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270)).select((Comparable)Direction.NORTH, Variant.variant());
        }
    }
}

