/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.blueprint;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.blockentity.FramedBlockEntity;
import xfacthd.framedblocks.api.blueprint.BlueprintData;
import xfacthd.framedblocks.api.util.CamoList;

public interface BlueprintCopyBehaviour {
    default public BlueprintData writeToBlueprint(Level level, BlockPos pos, BlockState state, FramedBlockEntity be) {
        return be.writeToBlueprint();
    }

    default public ItemStack getBlockItem(BlueprintData data) {
        return new ItemStack((ItemLike)data.block());
    }

    default public List<Property<?>> getPropertiesToCopy(BlockState state) {
        if (state.hasProperty((Property)FramedProperties.Y_SLOPE)) {
            return List.of(FramedProperties.Y_SLOPE);
        }
        return List.of();
    }

    default public CamoList getCamos(BlueprintData data) {
        return data.camos();
    }

    default public int getGlowstoneCount(BlueprintData data) {
        return data.glowing() ? 1 : 0;
    }

    default public int getIntangibleCount(BlueprintData data) {
        return data.intangible() ? 1 : 0;
    }

    default public int getReinforcementCount(BlueprintData data) {
        return data.reinforced() ? 1 : 0;
    }

    default public List<ItemStack> getAdditionalConsumedMaterials(BlueprintData data) {
        return List.of();
    }

    default public void postProcessPaste(Level level, BlockPos pos, Player player, BlueprintData data, ItemStack dummyStack) {
    }

    default public void attachDataToDummyRenderStack(ItemStack stack, BlueprintData data) {
    }
}

