/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.IQuadTransformer;
import net.neoforged.neoforge.client.model.QuadTransformers;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.common.util.TriState;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.block.cache.StateCache;
import xfacthd.framedblocks.api.camo.CamoContainerHelper;
import xfacthd.framedblocks.api.camo.CamoContent;
import xfacthd.framedblocks.api.camo.block.BlockCamoContent;
import xfacthd.framedblocks.api.camo.empty.EmptyCamoContent;
import xfacthd.framedblocks.api.model.AbstractFramedBlockModel;
import xfacthd.framedblocks.api.model.cache.QuadCacheKey;
import xfacthd.framedblocks.api.model.data.FramedBlockData;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.util.ModelUtils;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.predicate.contex.ConTexMode;
import xfacthd.framedblocks.api.type.IBlockType;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.data.ConTexDataHandler;
import xfacthd.framedblocks.client.model.QuadTable;
import xfacthd.framedblocks.client.model.ReinforcementModel;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.config.ClientConfig;
import xfacthd.framedblocks.common.data.PropertyHolder;

public final class FramedBlockModel
extends AbstractFramedBlockModel {
    private static final FramedBlockData DEFAULT_DATA = new FramedBlockData(EmptyCamoContent.EMPTY, false);
    private static final ChunkRenderTypeSet BASE_MODEL_RENDER_TYPES = ModelUtils.CUTOUT;
    private static final int FLAG_NO_CAMO_ATL_MODEL = 1;
    private static final int FLAG_NO_CAMO_REINFORCED = 2;
    private static final int FLAG_NO_CAMO_SOLID_BG = 4;
    private static final BlockCamoContent[] DEFAULT_NO_CAMO_CONTENTS = FramedBlockModel.makeNoCamoContents(((Block)FBContent.BLOCK_FRAMED_CUBE.value()).defaultBlockState());
    private static final UnaryOperator<BakedQuad> EMISSIVE_PROCESSOR = arg_0 -> ((IQuadTransformer)QuadTransformers.settingMaxEmissivity()).process(arg_0);
    private final Map<QuadCacheKey, QuadTable> quadCache = new ConcurrentHashMap<QuadCacheKey, QuadTable>();
    private final Map<QuadCacheKey, CachedRenderTypes> renderTypeCache = new ConcurrentHashMap<QuadCacheKey, CachedRenderTypes>();
    private final Geometry geometry;
    private final IBlockType type;
    private final boolean isBaseCube;
    private final boolean forceUngeneratedBaseModel;
    private final boolean useBaseModel;
    private final boolean useSolidBase;
    private final boolean uncachedPostProcess;
    private final StateCache stateCache;
    private final Predicate<Direction> xformDirFilter;
    private final BlockCamoContent[] noCamoContents;

    public FramedBlockModel(GeometryFactory.Context ctx, Geometry geometry) {
        super(ctx.baseModel(), ctx.state(), geometry.getItemModelInfo());
        BlockState state = ctx.state();
        this.geometry = geometry;
        this.type = ((IFramedBlock)state.getBlock()).getBlockType();
        this.isBaseCube = state.getBlock() == FBContent.BLOCK_FRAMED_CUBE.value();
        this.forceUngeneratedBaseModel = geometry.forceUngeneratedBaseModel();
        this.useBaseModel = geometry.useBaseModel();
        this.useSolidBase = geometry.useSolidNoCamoModel();
        this.uncachedPostProcess = geometry.hasUncachedPostProcessing();
        this.stateCache = ((IFramedBlock)state.getBlock()).getCache(state);
        this.xformDirFilter = geometry.transformAllQuads() ? d -> true : d -> !this.stateCache.isFullFace((Direction)d);
        this.noCamoContents = this.isBaseCube ? FramedBlockModel.makeNoCamoContents(state) : DEFAULT_NO_CAMO_CONTENTS;
        Preconditions.checkState((this.useBaseModel || !this.forceUngeneratedBaseModel ? 1 : 0) != 0, (Object)"Geometry::useBaseModel() must return true when Geometry::forceUngeneratedBaseModel() returns true");
        Preconditions.checkState((!this.useSolidBase || !this.useBaseModel ? 1 : 0) != 0, (Object)"Geometry#useSolidNoCamoModel() and Geometry#useBaseModel() cannot both return true");
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, @Nullable RenderType renderType) {
        CamoContent camoState = EmptyCamoContent.EMPTY;
        FramedBlockData data = (FramedBlockData)extraData.get(FramedBlockData.PROPERTY);
        if (data != null) {
            if (side != null && data.isSideHidden(side)) {
                return List.of();
            }
            camoState = data.getCamoContent();
            if (camoState != null && !camoState.isEmpty()) {
                return this.getCamoQuads(camoState, side, rand, extraData, data, renderType);
            }
        }
        if (data == null) {
            data = DEFAULT_DATA;
        }
        if (camoState == null || camoState.isEmpty()) {
            return this.getCamoQuads(null, side, rand, extraData, data, renderType);
        }
        return List.of();
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
        return this.getCamoQuads(null, side, rand, ModelData.EMPTY, DEFAULT_DATA, RenderType.cutout());
    }

    public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        EmptyCamoContent camoContent;
        FramedBlockData fbData = (FramedBlockData)data.get(FramedBlockData.PROPERTY);
        if (this.isBaseCube && (fbData == null || fbData.getCamoContent().isEmpty())) {
            return this.originalModel.getRenderTypes(state, rand, data);
        }
        if (fbData == null) {
            fbData = DEFAULT_DATA;
        }
        CamoContent keyContent = camoContent = fbData.getCamoContent();
        if (camoContent == null || camoContent.isEmpty()) {
            camoContent = EmptyCamoContent.EMPTY;
            keyContent = this.getNoCamoModelSourceContent(fbData);
        }
        return this.getCachedRenderTypes(keyContent, camoContent, (RandomSource)rand, (ModelData)data).allTypes;
    }

    private CachedRenderTypes getCachedRenderTypes(CamoContent<?> keyContent, CamoContent<?> camoContent, RandomSource rand, ModelData data) {
        QuadCacheKey key = this.geometry.makeCacheKey(keyContent, null, data);
        CachedRenderTypes cachedTypes = this.renderTypeCache.get(key);
        if (cachedTypes == null) {
            cachedTypes = this.buildRenderTypeCache(camoContent, rand, data);
            this.renderTypeCache.put(key, cachedTypes);
        }
        return cachedTypes;
    }

    private CachedRenderTypes buildRenderTypeCache(CamoContent<?> camoState, RandomSource rand, ModelData data) {
        ChunkRenderTypeSet camoTypes = BASE_MODEL_RENDER_TYPES;
        if (!camoState.isEmpty()) {
            camoTypes = CamoContainerHelper.Client.getRenderTypes(camoState, rand, data);
        }
        return new CachedRenderTypes(camoTypes, this.geometry.getAdditionalRenderTypes(rand, data), this.geometry.getOverlayRenderTypes(rand, data));
    }

    private List<BakedQuad> getCamoQuads(@Nullable CamoContent<?> camoContent, @Nullable Direction side, RandomSource rand, ModelData extraData, FramedBlockData fbData, @Nullable RenderType renderType) {
        CachedRenderTypes renderTypes;
        ModelData camoData;
        BakedModel camoModel;
        boolean reinforce;
        boolean needCtCtx;
        boolean nullLayer = renderType == null;
        boolean noProcessing = this.stateCache.isFullFace(side);
        if (camoContent == null) {
            needCtCtx = false;
            camoContent = this.getNoCamoModelSourceContent(fbData);
            reinforce = this.useBaseModel && fbData.isReinforced() && renderType == RenderType.cutout() && side != null;
            noProcessing |= this.forceUngeneratedBaseModel && (nullLayer || BASE_MODEL_RENDER_TYPES.contains(renderType));
            camoModel = this.getCamoModel(camoContent, this.useBaseModel, fbData.useAltModel());
            camoData = ModelData.EMPTY;
            renderTypes = this.getCachedRenderTypes(EmptyCamoContent.EMPTY, camoContent, rand, extraData);
        } else {
            needCtCtx = this.type.supportsConnectedTextures() && FramedBlockModel.needCtContext(noProcessing, this.type.getMinimumConTexMode());
            camoModel = this.getCamoModel(camoContent, false, false);
            camoData = needCtCtx ? ModelUtils.getCamoModelData(extraData) : ModelData.EMPTY;
            renderTypes = this.getCachedRenderTypes(camoContent, camoContent, rand, extraData);
            reinforce = false;
        }
        if (noProcessing) {
            boolean additionalQuads;
            boolean camoInRenderType = nullLayer || renderTypes.camoTypes.contains(renderType);
            boolean bl = additionalQuads = !nullLayer && renderTypes.additionalTypes.contains(renderType);
            if (!(camoInRenderType || additionalQuads || reinforce)) {
                return List.of();
            }
            boolean needCopy = additionalQuads || reinforce || this.uncachedPostProcess;
            List<BakedQuad> quads = List.of();
            if (camoInRenderType) {
                quads = camoModel.getQuads(camoContent.getAppearanceState(), side, rand, camoData, renderType);
                if (quads.isEmpty()) {
                    quads = ModelUtils.getFilteredNullQuads(camoModel, camoContent.getAppearanceState(), rand, camoData, renderType, side);
                }
                if (camoContent.isEmissive()) {
                    quads = Utils.copyAllWithModifier(quads, new ArrayList(quads.size()), EMISSIVE_PROCESSOR);
                    needCopy = false;
                }
            }
            if (needCopy) {
                quads = Utils.copyAll(quads, new ArrayList(quads.size()));
            }
            if (additionalQuads) {
                this.geometry.getAdditionalQuads((ArrayList<BakedQuad>)quads, side, rand, extraData, renderType);
            }
            if (reinforce) {
                quads.add(ReinforcementModel.getQuad(side));
            }
            if (this.uncachedPostProcess) {
                this.geometry.postProcessUncachedQuads(quads);
            }
            return quads;
        }
        Object ctCtx = needCtCtx ? ConTexDataHandler.extractConTexData(camoData) : null;
        QuadCacheKey key = this.geometry.makeCacheKey(camoContent, ctCtx, extraData);
        QuadTable quadTable = this.quadCache.get(key);
        if (quadTable == null) {
            ModelData ctData = ctCtx != null ? camoData : ModelData.EMPTY;
            quadTable = this.buildQuadCache(key.camo(), camoModel, rand, extraData, ctData, renderTypes, reinforce);
            this.quadCache.put(key, quadTable);
        }
        return nullLayer ? quadTable.getAllQuads(side) : quadTable.getQuads(renderType, side);
    }

    private static boolean needCtContext(boolean noProcessing, ConTexMode minMode) {
        ConTexMode mode = ClientConfig.VIEW.getConTexMode();
        if (mode == ConTexMode.NONE) {
            return false;
        }
        return noProcessing || mode.atleast(ConTexMode.FULL_EDGE) && mode.atleast(minMode);
    }

    private QuadTable buildQuadCache(CamoContent<?> camoContent, BakedModel camoModel, RandomSource rand, ModelData data, ModelData camoData, CachedRenderTypes renderTypes, boolean reinforce) {
        QuadTable quadTable = new QuadTable();
        UnaryOperator<Object> preprocessor = camoContent.isEmissive() ? EMISSIVE_PROCESSOR : UnaryOperator.identity();
        for (RenderType renderType : renderTypes.camoTypes) {
            quadTable.initializeForLayer(renderType);
            ArrayList<BakedQuad> quads = ModelUtils.getCullableQuads(camoModel, camoContent.getAppearanceState(), rand, camoData, renderType, this.xformDirFilter);
            if (reinforce && renderType == RenderType.cutout()) {
                ReinforcementModel.getFiltered(quads, this.xformDirFilter);
            }
            for (BakedQuad quad : quads) {
                quad = (BakedQuad)preprocessor.apply(quad);
                this.geometry.transformQuad(quadTable, quad, data);
            }
        }
        for (RenderType renderType : renderTypes.additionalTypes) {
            quadTable.initializeForLayer(renderType);
            this.geometry.getAdditionalQuads(quadTable, rand, data, renderType);
        }
        for (RenderType renderType : renderTypes.overlayTypes) {
            quadTable.initializeForLayer(renderType);
            this.geometry.getGeneratedOverlayQuads(quadTable, rand, data, renderType);
        }
        quadTable.bindRenderType(null);
        quadTable.trim();
        return quadTable;
    }

    private CamoContent<?> getNoCamoModelSourceContent(FramedBlockData fbData) {
        int idx = 0;
        if (fbData.useAltModel()) {
            idx |= 1;
        }
        if (fbData.isReinforced()) {
            idx |= 2;
        }
        if (ClientConfig.VIEW.getSolidFrameMode().useSolidFrame(this.useSolidBase)) {
            idx |= 4;
        }
        return this.noCamoContents[idx];
    }

    private static BlockCamoContent[] makeNoCamoContents(BlockState state) {
        BlockCamoContent[] contents = new BlockCamoContent[8];
        for (int i = 0; i < contents.length; ++i) {
            BlockState stateOut = state;
            if ((i & 1) != 0) {
                stateOut = (BlockState)stateOut.setValue((Property)PropertyHolder.ALT, (Comparable)Boolean.valueOf(true));
            }
            if ((i & 2) != 0) {
                stateOut = (BlockState)stateOut.setValue((Property)PropertyHolder.REINFORCED, (Comparable)Boolean.valueOf(true));
            }
            if ((i & 4) != 0) {
                stateOut = (BlockState)stateOut.setValue((Property)PropertyHolder.SOLID_BG, (Comparable)Boolean.valueOf(true));
            }
            contents[i] = new BlockCamoContent(stateOut);
        }
        return contents;
    }

    private BakedModel getCamoModel(CamoContent<?> camoContent, boolean useBaseModel, boolean useAltModel) {
        if (useBaseModel) {
            return this.geometry.getBaseModel(this.originalModel, useAltModel);
        }
        return CamoContainerHelper.Client.getOrCreateModel(camoContent);
    }

    public ModelData getModelData(BlockAndTintGetter level, BlockPos pos, BlockState state, ModelData tileData) {
        if (!this.type.supportsConnectedTextures()) {
            return tileData;
        }
        FramedBlockData data = (FramedBlockData)tileData.get(FramedBlockData.PROPERTY);
        if (data == null) {
            return tileData;
        }
        CamoContent<?> camoContent = data.getCamoContent();
        ModelData camoData = ModelData.EMPTY;
        if (!camoContent.isEmpty() && FramedBlockModel.needCtContext(this.stateCache.hasAnyFullFace(), this.type.getMinimumConTexMode())) {
            BakedModel model = CamoContainerHelper.Client.getOrCreateModel(camoContent);
            try {
                camoData = model.getModelData(level, pos, state, ModelData.EMPTY);
            }
            catch (Throwable t) {
                camoData = model.getModelData(level, pos, camoContent.getAppearanceState(), ModelData.EMPTY);
            }
        }
        ModelData auxData = this.geometry.getAuxModelData(level, pos, state, tileData);
        if (camoData != ModelData.EMPTY || auxData != ModelData.EMPTY) {
            ModelData.Builder builder = tileData.derive();
            if (camoData != ModelData.EMPTY) {
                builder.with(FramedBlockData.CAMO_DATA, (Object)camoData);
            }
            if (auxData != ModelData.EMPTY) {
                builder.with(FramedBlockData.AUX_DATA, (Object)auxData);
            }
            tileData = builder.build();
        }
        return tileData;
    }

    public TextureAtlasSprite getParticleIcon(ModelData data) {
        CamoContent<?> camoState;
        FramedBlockData fbdata = (FramedBlockData)data.get(FramedBlockData.PROPERTY);
        if (fbdata != null && !(camoState = fbdata.getCamoContent()).isEmpty()) {
            return this.getCamoModel(camoState, false, false).getParticleIcon();
        }
        return this.originalModel.getParticleIcon();
    }

    public TriState useAmbientOcclusion(BlockState state, ModelData data, RenderType renderType) {
        return this.geometry.useAmbientOcclusion(state, data, renderType);
    }

    public BakedModel getBaseModel() {
        return this.originalModel;
    }

    @Override
    public void clearCache() {
        super.clearCache();
        this.quadCache.clear();
        this.renderTypeCache.clear();
    }

    private record CachedRenderTypes(ChunkRenderTypeSet camoTypes, ChunkRenderTypeSet additionalTypes, ChunkRenderTypeSet overlayTypes, ChunkRenderTypeSet allTypes) {
        public CachedRenderTypes(ChunkRenderTypeSet camoTypes, ChunkRenderTypeSet additionalTypes, ChunkRenderTypeSet overlayTypes) {
            this(camoTypes, additionalTypes, overlayTypes, ChunkRenderTypeSet.union((ChunkRenderTypeSet[])new ChunkRenderTypeSet[]{camoTypes, additionalTypes, overlayTypes}));
        }
    }
}

