/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.compat.emi;

import dev.emi.emi.api.EmiDragDropHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import xfacthd.framedblocks.client.screen.FramingSawWithEncoderScreen;
import xfacthd.framedblocks.common.crafting.FramingSawRecipe;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeAdditive;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeCache;

public final class FramingSawDragDropHandler
implements EmiDragDropHandler<FramingSawWithEncoderScreen> {
    public void render(FramingSawWithEncoderScreen screen, EmiIngredient dragged, GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        if (FramingSawDragDropHandler.isFramedBlock(dragged)) {
            int x = screen.getInputSlotX() - 1;
            int y = screen.getInputSlotY(0) - 1;
            graphics.fill(x, y, x + 18, y + 18, -2010989773);
        } else if (dragged instanceof EmiStack) {
            EmiStack emiStack = (EmiStack)dragged;
            ItemStack stack = emiStack.getItemStack();
            RecipeHolder<FramingSawRecipe> recipe = screen.getMenu().getRecipes().get(screen.getMenu().getSelectedRecipeIndex()).toVanilla();
            List<FramingSawRecipeAdditive> additives = ((FramingSawRecipe)recipe.value()).getAdditives();
            for (int i = 0; i < additives.size(); ++i) {
                if (!additives.get(i).ingredient().test(stack)) continue;
                int x = screen.getInputSlotX() - 1;
                int y = screen.getInputSlotY(i + 1) - 1;
                graphics.fill(x, y, x + 18, y + 18, -2010989773);
                break;
            }
        }
    }

    public boolean dropStack(FramingSawWithEncoderScreen screen, EmiIngredient ingredient, int dropX, int dropY) {
        if (FramingSawDragDropHandler.isFramedBlock(ingredient)) {
            int x = screen.getInputSlotX();
            int y = screen.getInputSlotY(0);
            if (dropX >= x && dropX < x + 16 && dropY >= y && dropY < y + 16) {
                screen.acceptEncodingInput(0, ((EmiStack)ingredient).getItemStack());
                return true;
            }
        } else if (ingredient instanceof EmiStack) {
            EmiStack emiStack = (EmiStack)ingredient;
            ItemStack stack = emiStack.getItemStack();
            RecipeHolder<FramingSawRecipe> recipe = screen.getMenu().getRecipes().get(screen.getMenu().getSelectedRecipeIndex()).toVanilla();
            List<FramingSawRecipeAdditive> additives = ((FramingSawRecipe)recipe.value()).getAdditives();
            for (int i = 0; i < additives.size(); ++i) {
                int x = screen.getInputSlotX();
                int y = screen.getInputSlotY(i + 1);
                if (dropX < x || dropX >= x + 16 || dropY < y || dropY >= y + 16 || !additives.get(i).ingredient().test(stack)) continue;
                screen.acceptEncodingInput(i + 1, emiStack.getItemStack());
                return true;
            }
        }
        return false;
    }

    private static boolean isFramedBlock(EmiIngredient ingredient) {
        if (ingredient instanceof EmiStack) {
            EmiStack emiStack = (EmiStack)ingredient;
            Item stack = emiStack.getItemStack().getItem();
            return FramingSawRecipeCache.get(true).getMaterialValue(stack) > 0;
        }
        return false;
    }
}

