/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.shapes.slopeedge;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.shapes.ShapeCache;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.shapes.ShapeUtils;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.data.shapes.SplitShapeGenerator;

public final class SlopeEdgeShapes
implements SplitShapeGenerator {
    public static final ShapeCache<ShapeKey> SHAPES = SlopeEdgeShapes.makeCache(() -> ShapeUtils.orUnoptimized(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)8.0), Block.box((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)8.0, (double)4.0)));
    public static final ShapeCache<ShapeKey> OCCLUSION_SHAPES = SlopeEdgeShapes.makeCache(() -> ShapeUtils.orUnoptimized(Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.25, (double)8.0), Block.box((double)0.0, (double)0.25, (double)0.0, (double)16.0, (double)4.0, (double)7.75), Block.box((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)7.75, (double)4.0), Block.box((double)0.0, (double)7.75, (double)0.0, (double)16.0, (double)8.0, (double)0.25)));

    @Override
    public ShapeProvider generate(ImmutableList<BlockState> states) {
        return SlopeEdgeShapes.generate(states, SHAPES);
    }

    @Override
    public ShapeProvider generateOcclusionShapes(ImmutableList<BlockState> states) {
        return SlopeEdgeShapes.generate(states, OCCLUSION_SHAPES);
    }

    private static ShapeProvider generate(ImmutableList<BlockState> states, ShapeCache<ShapeKey> cache) {
        VoxelShape[] shapes = new VoxelShape[24];
        for (SlopeType type : SlopeType.values()) {
            ShapeUtils.makeHorizontalRotations(cache.get(new ShapeKey(type, false)), Direction.NORTH, shapes, type, (dir, keyType) -> SlopeEdgeShapes.makeShapeIndex(dir, keyType, false));
            ShapeUtils.makeHorizontalRotations(cache.get(new ShapeKey(type, true)), Direction.NORTH, shapes, type, (dir, keyType) -> SlopeEdgeShapes.makeShapeIndex(dir, keyType, true));
        }
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (BlockState state : states) {
            SlopeType type;
            type = (SlopeType)((Object)state.getValue(PropertyHolder.SLOPE_TYPE));
            Direction dir2 = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            boolean altType = (Boolean)state.getValue((Property)PropertyHolder.ALT_TYPE);
            builder.put((Object)state, (Object)shapes[SlopeEdgeShapes.makeShapeIndex(dir2, type, altType)]);
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    private static int makeShapeIndex(Direction dir, SlopeType type, boolean altType) {
        return type.ordinal() << 3 | dir.get2DDataValue() << 1 | (altType ? 1 : 0);
    }

    private static ShapeCache<ShapeKey> makeCache(Supplier<VoxelShape> bottomShape) {
        return ShapeCache.create(map -> {
            VoxelShape shapeBottom = (VoxelShape)bottomShape.get();
            map.put(new ShapeKey(SlopeType.BOTTOM, false), shapeBottom);
            map.put(new ShapeKey(SlopeType.BOTTOM, true), shapeBottom.move(0.0, 0.5, 0.5));
            VoxelShape shapeTop = ShapeUtils.rotateShapeUnoptimizedAroundZ(Direction.DOWN, Direction.UP, shapeBottom);
            map.put(new ShapeKey(SlopeType.TOP, false), shapeTop);
            map.put(new ShapeKey(SlopeType.TOP, true), shapeTop.move(0.0, -0.5, 0.5));
            VoxelShape shapeHorizontal = ShapeUtils.rotateShapeUnoptimizedAroundZ(Direction.DOWN, Direction.WEST, shapeBottom);
            map.put(new ShapeKey(SlopeType.HORIZONTAL, false), shapeHorizontal);
            map.put(new ShapeKey(SlopeType.HORIZONTAL, true), shapeHorizontal.move(0.5, 0.0, 0.5));
        });
    }

    public record ShapeKey(SlopeType type, boolean altType) {
    }
}

