/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.menu;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.blockentity.special.PoweredFramingSawBlockEntity;
import xfacthd.framedblocks.common.capability.RecipeInputItemStackHandler;
import xfacthd.framedblocks.common.crafting.FramingSawRecipe;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeCache;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeMatchResult;
import xfacthd.framedblocks.common.menu.IFramingSawMenu;
import xfacthd.framedblocks.common.util.FramedUtils;

public class PoweredFramingSawMenu
extends AbstractContainerMenu
implements IFramingSawMenu {
    private final PoweredFramingSawBlockEntity blockEntity;
    private final RecipeInputItemStackHandler itemHandler;
    private final DataSlot progressSlot;
    private final DataSlot recipeIdxSlot;
    private final DataSlot recipeStatusSlot;
    private final DataSlot energySlot;
    private final DataSlot capacitySlot;
    private final DataSlot durationSlot;
    private final FramingSawRecipeCache cache;
    @Nullable
    private RecipeHolder<FramingSawRecipe> lastRecipe = null;

    public PoweredFramingSawMenu(int windowId, Inventory inv, FriendlyByteBuf buf) {
        this(windowId, inv, inv.player.level(), buf.readBlockPos());
    }

    public PoweredFramingSawMenu(int windowId, Inventory inv, Level level, BlockPos pos) {
        super((MenuType)FBContent.MENU_TYPE_POWERED_FRAMING_SAW.value(), windowId);
        BlockEntity be = level.getBlockEntity(pos);
        Preconditions.checkState((boolean)(be instanceof PoweredFramingSawBlockEntity));
        this.blockEntity = (PoweredFramingSawBlockEntity)be;
        this.cache = FramingSawRecipeCache.get(level.isClientSide());
        this.progressSlot = this.addDataSlot(DataSlot.standalone());
        this.recipeIdxSlot = this.addDataSlot((DataSlot)(!level.isClientSide() ? DataSlot.standalone() : new RecipeIndexDataSlot()));
        this.recipeStatusSlot = this.addDataSlot(DataSlot.standalone());
        this.energySlot = this.addDataSlot(DataSlot.standalone());
        this.capacitySlot = this.addDataSlot(DataSlot.standalone());
        this.durationSlot = this.addDataSlot(DataSlot.standalone());
        this.itemHandler = PoweredFramingSawMenu.makeItemHandler(this.blockEntity.getItemHandler(), level);
        for (int i = 0; i <= 4; ++i) {
            int x;
            switch (i) {
                case 0: {
                    int n = 34;
                    break;
                }
                case 4: {
                    int n = 148;
                    break;
                }
                default: {
                    int n = x = 38 + i * 18;
                }
            }
            if (i >= 1 && i < 4) {
                this.addSlot((Slot)new AdditiveSlot((IItemHandler)this.itemHandler, i, x, 46));
                continue;
            }
            this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.itemHandler, i, x, 46));
        }
        FramedUtils.addPlayerInvSlots(x$0 -> this.addSlot((Slot)x$0), inv, 8, 100);
        this.recipeIdxSlot.set(-1);
        if (!level.isClientSide()) {
            this.capacitySlot.set(this.blockEntity.getEnergyCapacity());
            this.durationSlot.set(this.blockEntity.getCraftingDuration());
        }
    }

    private static RecipeInputItemStackHandler makeItemHandler(RecipeInputItemStackHandler handler, Level level) {
        if (level.isClientSide()) {
            handler = new RecipeInputItemStackHandler(handler.getSlots());
        }
        return handler;
    }

    public void broadcastChanges() {
        FramingSawRecipeMatchResult matchResult;
        this.progressSlot.set(this.blockEntity.getProgress());
        RecipeHolder<FramingSawRecipe> recipe = this.blockEntity.getSelectedRecipe();
        if (!Objects.equals(this.lastRecipe, recipe)) {
            this.recipeIdxSlot.set(recipe == null ? -1 : this.cache.getRecipes().indexOf(recipe));
            this.handleRecipeChange(recipe);
        }
        this.recipeStatusSlot.set((matchResult = this.blockEntity.getMatchResult()) == null ? -1 : matchResult.ordinal());
        this.energySlot.set(this.blockEntity.getEnergy());
        super.broadcastChanges();
    }

    private void handleRecipeChange(RecipeHolder<FramingSawRecipe> recipe) {
        this.lastRecipe = recipe;
        int additiveCount = recipe != null ? ((FramingSawRecipe)recipe.value()).getAdditives().size() : 3;
        for (int i = 0; i < 3; ++i) {
            AdditiveSlot slot = (AdditiveSlot)this.getSlot(1 + i);
            slot.active = i < additiveCount;
        }
    }

    public boolean clickMenuButton(Player player, int id) {
        if (id == -1) {
            this.blockEntity.selectRecipe(null);
            return true;
        }
        List<RecipeHolder<FramingSawRecipe>> recipes = this.cache.getRecipes();
        if (id >= 0 && id < recipes.size()) {
            this.blockEntity.selectRecipe(recipes.get(id));
            return true;
        }
        return super.clickMenuButton(player, id);
    }

    public RecipeHolder<FramingSawRecipe> getSelectedRecipe() {
        return this.lastRecipe;
    }

    public int getProgress() {
        return this.progressSlot.get();
    }

    public FramingSawRecipeMatchResult getMatchResult() {
        int result = this.recipeStatusSlot.get();
        return result == -1 ? null : FramingSawRecipeMatchResult.valueOf(result);
    }

    public int getEnergy() {
        return this.energySlot.get();
    }

    public int getEnergyCapacity() {
        return this.capacitySlot.get();
    }

    public int getCraftingDuration() {
        return this.durationSlot.get();
    }

    @Override
    public ItemStack getInputStack() {
        return this.getSlot(0).getItem();
    }

    @Override
    public RecipeInput getRecipeInput() {
        return this.itemHandler;
    }

    @Override
    public ItemStack getAdditiveStack(int slot) {
        return this.getSlot(1 + slot).getItem();
    }

    @Override
    public boolean isValidRecipeIndex(int idx) {
        return idx >= 0 && idx < this.cache.getRecipes().size();
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack remainder = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack stack = slot.getItem();
            remainder = stack.copy();
            if (index == 4) {
                stack.getItem().onCraftedBy(stack, player.level(), player);
                if (!this.moveItemStackTo(stack, 5, this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(stack, remainder);
            } else if (index < 5 ? !this.moveItemStackTo(stack, 5, this.slots.size(), true) : (this.cache.getMaterialValue(stack.getItem()) > 0 ? !this.moveItemStackTo(stack, 0, 1, false) : !this.moveItemStackTo(stack, 1, 4, false))) {
                return ItemStack.EMPTY;
            }
            if (stack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (stack.getCount() == remainder.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, stack);
        }
        return remainder;
    }

    public boolean stillValid(Player player) {
        return this.blockEntity.isUsableByPlayer(player);
    }

    private final class RecipeIndexDataSlot
    extends DataSlot {
        private int index = -1;

        private RecipeIndexDataSlot() {
        }

        public int get() {
            return this.index;
        }

        public void set(int value) {
            this.index = value;
            PoweredFramingSawMenu.this.handleRecipeChange(value == -1 ? null : PoweredFramingSawMenu.this.cache.getRecipes().get(value));
        }
    }

    private static final class AdditiveSlot
    extends SlotItemHandler {
        private boolean active = true;

        public AdditiveSlot(IItemHandler handler, int idx, int x, int y) {
            super(handler, idx, x, y);
        }

        public boolean isActive() {
            return this.active || this.hasItem();
        }

        public boolean isHighlightable() {
            return this.active || this.hasItem();
        }

        public boolean mayPlace(@NotNull ItemStack stack) {
            return this.active && super.mayPlace(stack);
        }
    }
}

