/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client.components.options.types.color;

import com.teamresourceful.resourcefulconfig.client.components.options.types.color.HsbColor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class RecentColorStorage {
    private static final Set<HsbColor> nonAlpha = new LinkedHashSet<HsbColor>();
    private static final Map<HsbColor, HsbColor> alpha = new LinkedHashMap<HsbColor, HsbColor>();

    public static void add(HsbColor color) {
        if (color.alpha() == 255) {
            nonAlpha.remove(color);
            nonAlpha.add(color);
        } else {
            nonAlpha.remove(color.withAlpha(255));
            alpha.put(color.withAlpha(255), color);
        }
    }

    public static Collection<HsbColor> getRecentColors(boolean withAlpha) {
        ArrayList<HsbColor> colors = new ArrayList<HsbColor>(nonAlpha);
        if (withAlpha) {
            colors.addAll(alpha.values());
        }
        Collections.reverse(colors);
        return colors;
    }

    public static boolean hasValues() {
        return !nonAlpha.isEmpty() || !alpha.isEmpty();
    }
}

