/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.world.content.blocks;

import java.util.EnumMap;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.api.content.IColorSource;
import tv.soaryn.xycraft.core.content.BlockContent;
import tv.soaryn.xycraft.core.content.blocks.ColoredBlock;
import tv.soaryn.xycraft.core.content.blocks.CoreStateProperties;
import tv.soaryn.xycraft.core.utils.ColorUtils;
import tv.soaryn.xycraft.core.utils.DyeColors;
import tv.soaryn.xycraft.world.content.registries.WorldContent;

public class LampColoredBlock
extends ColoredBlock {
    private final DyeColor _dyeColor;
    private final boolean _inverted;

    protected LampColoredBlock(DyeColors color, BlockBehaviour.Properties properties, boolean isInverted) {
        super((IColorSource)color, properties.instrument(NoteBlockInstrument.XYLOPHONE).sound(SoundType.AMETHYST).destroyTime(Blocks.GLASS.defaultDestroyTime()).isRedstoneConductor((p_61036_, p_61037_, p_61038_) -> false));
        this._dyeColor = color.getDye();
        this._inverted = isInverted;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)CoreStateProperties.LightValue, (Comparable)Integer.valueOf(this._inverted ? 15 : 0)));
    }

    public static LampColoredBlock normal(DyeColors color, BlockBehaviour.Properties properties) {
        return new LampColoredBlock(color, properties, false);
    }

    public static LampColoredBlock inverted(DyeColors color, BlockBehaviour.Properties properties) {
        return new LampColoredBlock(color, properties, true);
    }

    public int getLightEmission(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return (Integer)state.getValue((Property)CoreStateProperties.LightValue);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{CoreStateProperties.Spawnable});
        builder.add(new Property[]{CoreStateProperties.LightValue});
    }

    @NotNull
    public ItemStack getCloneItemStack(@NotNull BlockState state, @NotNull HitResult target, @NotNull LevelReader level, @NotNull BlockPos pos, Player player) {
        if (player.isCreative()) {
            return super.getCloneItemStack(state, target, level, pos, player);
        }
        return new ItemStack((ItemLike)this.getCurrentMap().get(DyeColors.White).block(), 1);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        EnumMap<DyeColors, BlockContent> currentMap;
        BlockContent blockType;
        ItemInteractionResult interactionResult = ColoredBlock.tryToAllowSpawns((BlockState)state, (Level)level, (BlockPos)pos, (Player)player, (InteractionHand)hand);
        if (interactionResult != ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION) {
            return interactionResult;
        }
        DyeColor dyeColor = DyeColor.getColor((ItemStack)stack);
        if (dyeColor != null && dyeColor != this._dyeColor && (blockType = (currentMap = this.getCurrentMap()).get(DyeColors.from((DyeColor)dyeColor))).block() != this) {
            level.setBlock(pos, (BlockState)((BlockState)blockType.block().defaultBlockState().setValue((Property)CoreStateProperties.Spawnable, (Comparable)((Boolean)state.getValue((Property)CoreStateProperties.Spawnable)))).setValue((Property)CoreStateProperties.LightValue, (Comparable)((Integer)state.getValue((Property)CoreStateProperties.LightValue))), 11);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hit);
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        ItemStack offhandStack = Objects.requireNonNull(context.getPlayer()).getOffhandItem();
        BlockState state = this.defaultBlockState();
        DyeColors color = DyeColors.from((DyeColor)DyeColor.getColor((ItemStack)offhandStack));
        if (color != null) {
            state = this.getCurrentMap().get(color).block().defaultBlockState();
        }
        int redstone = context.getLevel().getBestNeighborSignal(context.getClickedPos());
        if (this._inverted) {
            redstone = 15 - redstone;
        }
        return (BlockState)((BlockState)state.setValue((Property)CoreStateProperties.Spawnable, (Comparable)Boolean.valueOf(false))).setValue((Property)CoreStateProperties.LightValue, (Comparable)Integer.valueOf(redstone));
    }

    private EnumMap<DyeColors, BlockContent> getCurrentMap() {
        return this._inverted ? WorldContent.Block.LampRgbGlowingInverted : WorldContent.Block.LampRgbGlowing;
    }

    public void neighborChanged(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Block otherBlock, @NotNull BlockPos otherPos, boolean p_55671_) {
        if (!level.isClientSide) {
            Integer lightValue = (Integer)state.getValue((Property)CoreStateProperties.LightValue);
            int redstone = level.getBestNeighborSignal(pos);
            if (this._inverted) {
                redstone = 15 - redstone;
            }
            if (lightValue != redstone) {
                level.setBlock(pos, (BlockState)state.setValue((Property)CoreStateProperties.LightValue, (Comparable)Integer.valueOf(redstone)), 2);
            }
        }
    }

    public void tick(BlockState state, ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource rand) {
        Integer lightValue = (Integer)state.getValue((Property)CoreStateProperties.LightValue);
        int redstone = level.getBestNeighborSignal(pos);
        if (this._inverted) {
            redstone = 15 - redstone;
        }
        if (lightValue != redstone) {
            level.setBlock(pos, (BlockState)state.setValue((Property)CoreStateProperties.LightValue, (Comparable)Integer.valueOf(redstone)), 2);
        }
    }

    public int getColorOfBlock(BlockState state, BlockAndTintGetter level, BlockPos pos, int index) {
        int color = this.ColorSource.getColor();
        float l = Mth.clamp((float)((float)((Integer)state.getValue((Property)CoreStateProperties.LightValue)).intValue() / 15.0f), (float)0.2f, (float)1.0f);
        return ColorUtils.multiply((int)color, (float)l);
    }

    public int getColorOfItem(ItemStack stack, int index) {
        if (index != 0) {
            return -1;
        }
        if (stack.getItem() == WorldContent.Block.LampRgbGlowing.get(DyeColors.White).item()) {
            return ColorUtils.multiply((int)ColorUtils.getColorTime((int)0), (float)0.2f);
        }
        if (stack.getItem() == WorldContent.Block.LampRgbGlowingInverted.get(DyeColors.White).item()) {
            return ColorUtils.getColorTime((int)0);
        }
        return this.ColorSource.getColor();
    }
}

