/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.api.farmland;

import com.blakebr0.mysticalagriculture.api.crop.CropTier;
import com.blakebr0.mysticalagriculture.api.crop.ICropTierProvider;
import com.blakebr0.mysticalagriculture.api.farmland.IEssenceFarmland;
import com.blakebr0.mysticalagriculture.api.farmland.IFarmlandConverter;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public final class FarmlandConverter {
    public static InteractionResult convert(IFarmlandConverter converter, UseOnContext context) {
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        ItemStack stack = context.getItemInHand();
        Player player = context.getPlayer();
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (block == Blocks.FARMLAND) {
            BlockState newState = (BlockState)converter.getConvertedFarmland().defaultBlockState().setValue((Property)FarmBlock.MOISTURE, (Comparable)((Integer)state.getValue((Property)FarmBlock.MOISTURE)));
            level.setBlockAndUpdate(pos, newState);
            level.playSound(player, pos, SoundEvents.SAND_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
            stack.shrink(1);
            return InteractionResult.SUCCESS;
        }
        if (block instanceof IEssenceFarmland) {
            ICropTierProvider provider;
            CropTier tier;
            IEssenceFarmland farmland = (IEssenceFarmland)block;
            Item item = stack.getItem();
            if (item instanceof ICropTierProvider && (tier = (provider = (ICropTierProvider)item).getTier()) != farmland.getTier()) {
                BlockState newState = (BlockState)converter.getConvertedFarmland().defaultBlockState().setValue((Property)FarmBlock.MOISTURE, (Comparable)((Integer)state.getValue((Property)FarmBlock.MOISTURE)));
                level.setBlockAndUpdate(pos, newState);
                level.playSound(player, pos, SoundEvents.SAND_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
                stack.shrink(1);
                if (Math.random() < 0.25) {
                    Block.popResource((Level)level, (BlockPos)pos.above(), (ItemStack)new ItemStack((ItemLike)farmland.getTier().getEssence()));
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }
}

