/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.block;

import com.blakebr0.cucumber.util.Localizable;
import com.blakebr0.mysticalagriculture.api.crop.Crop;
import com.blakebr0.mysticalagriculture.api.crop.ICropProvider;
import com.blakebr0.mysticalagriculture.config.ModConfigs;
import com.blakebr0.mysticalagriculture.init.ModItems;
import com.blakebr0.mysticalagriculture.lib.ModCrops;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MysticalCropBlock
extends CropBlock
implements ICropProvider {
    private static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    private final Crop crop;

    public MysticalCropBlock(Crop crop) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHEAT));
        this.crop = crop;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return false;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!this.canGrow((Level)level, pos)) {
            return;
        }
        super.randomTick(state, level, pos, random);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public String getDescriptionId() {
        return Localizable.of((String)"block.mysticalagriculture.mystical_crop").args(new Object[]{this.crop.getDisplayName()}).buildString();
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        int age = (Integer)state.getValue((Property)AGE);
        int crop = 0;
        int seed = 1;
        int fertilizer = 0;
        if (age == this.getMaxAge()) {
            crop = 1;
            Vec3 vec = (Vec3)builder.getOptionalParameter(LootContextParams.ORIGIN);
            if (vec != null) {
                ServerLevel level = builder.getLevel();
                BlockPos pos = BlockPos.containing((Position)vec);
                Block below = level.getBlockState(pos.below()).getBlock();
                double chance = this.crop.getSecondaryChance(below);
                if (Math.random() < chance) {
                    crop = 2;
                }
                if (((Boolean)ModConfigs.SECONDARY_SEED_DROPS.get()).booleanValue() && Math.random() < chance) {
                    seed = 2;
                }
                double fertilizerChance = (Double)ModConfigs.FERTILIZED_ESSENCE_DROP_CHANCE.get();
                if (Math.random() < fertilizerChance) {
                    fertilizer = 1;
                }
            }
        }
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (crop > 0) {
            drops.add(new ItemStack(this.getCropsItem(), crop));
        }
        drops.add(new ItemStack(this.getBaseSeedId(), seed));
        if (fertilizer > 0) {
            drops.add(new ItemStack((ItemLike)ModItems.FERTILIZED_ESSENCE.get()));
        }
        return drops;
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        if (!this.canGrow((Level)level, pos)) {
            return;
        }
        super.performBonemeal(level, random, pos, state);
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        if (level instanceof Level) {
            return this.canGrow((Level)level, pos) && super.isValidBonemealTarget(level, pos, state);
        }
        return super.isValidBonemealTarget(level, pos, state);
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return state.getBlock() instanceof FarmBlock;
    }

    protected ItemLike getBaseSeedId() {
        return this.crop.getSeedsItem();
    }

    @Override
    public Crop getCrop() {
        return this.crop;
    }

    protected ItemLike getCropsItem() {
        return this.crop.getEssenceItem();
    }

    private boolean canGrow(Level level, BlockPos pos) {
        Set<ResourceLocation> biomes;
        Block block;
        Block crux = this.crop.getCruxBlock();
        if (crux != null && (block = level.getBlockState(pos.below(2)).getBlock()) != crux) {
            return false;
        }
        if (((Boolean)ModConfigs.REQUIRES_EFFECTIVE_FARMLAND.get()).booleanValue() && this.crop != ModCrops.INFERIUM) {
            Block farmland = level.getBlockState(pos.below()).getBlock();
            if (!this.crop.getTier().isEffectiveFarmland(farmland)) {
                return false;
            }
        }
        if (!(biomes = this.crop.getRequiredBiomes()).isEmpty()) {
            ResourceKey biome = level.getBiome(pos).getKey();
            return biome != null && biomes.contains(biome.location());
        }
        return true;
    }
}

