/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.crafting.recipe;

import com.blakebr0.mysticalagriculture.api.crafting.IReprocessorRecipe;
import com.blakebr0.mysticalagriculture.init.ModRecipeSerializers;
import com.blakebr0.mysticalagriculture.init.ModRecipeTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.RecipeMatcher;

public class ReprocessorRecipe
implements IReprocessorRecipe {
    private final NonNullList<Ingredient> inputs;
    private final ItemStack result;

    public ReprocessorRecipe(Ingredient input, ItemStack result) {
        this.inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{input});
        this.result = result;
    }

    public boolean matches(CraftingInput inventory, Level level) {
        if (this.inputs.size() != inventory.ingredientCount()) {
            return false;
        }
        NonNullList inputs = NonNullList.create();
        for (int i = 0; i < inventory.size(); ++i) {
            ItemStack item = inventory.getItem(i);
            if (item.isEmpty()) continue;
            inputs.add((Object)item);
        }
        return RecipeMatcher.findMatches((List)inputs, this.inputs) != null;
    }

    public ItemStack assemble(CraftingInput inventory, HolderLookup.Provider provider) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return this.result;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.inputs;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.REPROCESSOR.get();
    }

    public RecipeType<? extends IReprocessorRecipe> getType() {
        return (RecipeType)ModRecipeTypes.REPROCESSOR.get();
    }

    public static class Serializer
    implements RecipeSerializer<ReprocessorRecipe> {
        public static final MapCodec<ReprocessorRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("input").forGetter(recipe -> (Ingredient)recipe.inputs.getFirst()), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result)).apply((Applicative)builder, ReprocessorRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ReprocessorRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<ReprocessorRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ReprocessorRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static ReprocessorRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            Ingredient input = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            return new ReprocessorRecipe(input, result);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, ReprocessorRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)((Ingredient)recipe.inputs.getFirst()));
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
        }
    }
}

