/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.item;

import com.blakebr0.mysticalagriculture.init.ModDataComponentTypes;
import com.blakebr0.mysticalagriculture.item.WateringCanItem;
import com.blakebr0.mysticalagriculture.lib.ModTooltips;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class EssenceWateringCanItem
extends WateringCanItem {
    private final ChatFormatting textColor;

    public EssenceWateringCanItem(int range, double chance, ChatFormatting textColor) {
        super(range, chance, (Item.Properties p) -> p.component(ModDataComponentTypes.WATERING_CAN_ACTIVE, (Object)false));
        this.textColor = textColor;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        Player player;
        boolean isActive = EssenceWateringCanItem.isActive(stack);
        if (selected && isActive && entity instanceof Player) {
            player = (Player)entity;
            BlockHitResult trace = EssenceWateringCanItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
            if (trace.getType() == HitResult.Type.BLOCK) {
                this.doWater(stack, level, player, trace.getBlockPos(), trace.getDirection());
            } else {
                EssenceWateringCanItem.stopPlayingSound((Player)player);
            }
        }
        if (!selected && isActive && entity instanceof Player) {
            player = (Player)entity;
            EssenceWateringCanItem.stopPlayingSound((Player)player);
        }
    }

    public boolean isFoil(ItemStack stack) {
        return EssenceWateringCanItem.isActive(stack);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        FluidState fluid;
        ItemStack stack = player.getItemInHand(hand);
        BlockHitResult trace = EssenceWateringCanItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (trace.getType() != HitResult.Type.BLOCK) {
            if (EssenceWateringCanItem.isFilled((ItemStack)stack) && player.isCrouching()) {
                EssenceWateringCanItem.flipActive(stack);
            }
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        if (EssenceWateringCanItem.isFilled((ItemStack)stack)) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        BlockPos pos = trace.getBlockPos();
        Direction direction = trace.getDirection();
        if (level.mayInteract(player, pos) && player.mayUseItemAt(pos.relative(direction), direction, stack) && (fluid = level.getFluidState(pos)).is(FluidTags.WATER)) {
            EssenceWateringCanItem.setFilled((ItemStack)stack, (boolean)true);
            player.playSound(SoundEvents.BUCKET_FILL, 1.0f, 1.0f);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        InteractionHand hand = context.getHand();
        ItemStack stack = player.getItemInHand(hand);
        if (EssenceWateringCanItem.isActive(stack)) {
            return InteractionResult.PASS;
        }
        return super.useOn(context);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag advanced) {
        super.appendHoverText(stack, context, tooltip, advanced);
        String rangeString = String.valueOf(this.range);
        MutableComponent rangeNumber = Component.literal((String)(rangeString + "x" + rangeString)).withStyle(this.textColor);
        tooltip.add((Component)ModTooltips.TOOL_AREA.args(new Object[]{rangeNumber}).build());
    }

    public static boolean isActive(ItemStack stack) {
        return (Boolean)stack.getOrDefault(ModDataComponentTypes.WATERING_CAN_ACTIVE, (Object)false);
    }

    public static void setActive(ItemStack stack, boolean active) {
        stack.set(ModDataComponentTypes.WATERING_CAN_ACTIVE, (Object)active);
    }

    public static void flipActive(ItemStack stack) {
        boolean current = EssenceWateringCanItem.isActive(stack);
        EssenceWateringCanItem.setActive(stack, !current);
    }
}

