/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.camol.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.camol.Camol;
import cy.jdkdigital.camol.common.item.CamoItem;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class ConvertCamoCraftingRecipe
implements CraftingRecipe {
    private final ItemStack camoInput;
    private final ItemStack camoOutput;

    public ConvertCamoCraftingRecipe(ItemStack camoInput, ItemStack camoOutput) {
        this.camoInput = camoInput;
        this.camoOutput = camoOutput;
    }

    public CraftingBookCategory category() {
        return CraftingBookCategory.MISC;
    }

    public boolean matches(CraftingInput input, Level level) {
        return input.ingredientCount() == 1 && input.items().stream().filter(itemStack -> itemStack.is(this.camoInput.getItem())).toList().size() == 1;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        ItemStack camoItem = input.items().stream().filter(itemStack -> itemStack.is(this.camoInput.getItem())).toList().getFirst();
        if (camoItem.has(Camol.BLOCK_COMPONENT)) {
            return CamoItem.getCamoItem((BlockState)camoItem.get(Camol.BLOCK_COMPONENT), this.camoOutput.copy());
        }
        return this.camoOutput.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 1;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.camoOutput.copy();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)Camol.CONVERT_CAMO_CRAFTING.get();
    }

    public static class Serializer
    implements RecipeSerializer<ConvertCamoCraftingRecipe> {
        private static final MapCodec<ConvertCamoCraftingRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ItemStack.CODEC.fieldOf("camo_input").forGetter(recipe -> recipe.camoInput), (App)ItemStack.CODEC.fieldOf("camo_output").forGetter(recipe -> recipe.camoOutput)).apply((Applicative)builder, ConvertCamoCraftingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, ConvertCamoCraftingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<ConvertCamoCraftingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ConvertCamoCraftingRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static ConvertCamoCraftingRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            return new ConvertCamoCraftingRecipe((ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer), (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer));
        }

        public static void toNetwork(RegistryFriendlyByteBuf buffer, ConvertCamoCraftingRecipe recipe) {
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.camoInput);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.camoOutput);
        }
    }
}

